% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixbeta.R
\name{mixbeta}
\alias{mixbeta}
\alias{ms2beta}
\alias{mn2beta}
\alias{print.betaMix}
\alias{print.betaBinomialMix}
\alias{summary.betaMix}
\alias{summary.betaBinomialMix}
\title{Beta Mixture Density}
\usage{
mixbeta(..., param = c("ab", "ms", "mn"))

ms2beta(m, s, drop = TRUE)

mn2beta(m, n, drop = TRUE)

\method{print}{betaMix}(x, ...)

\method{print}{betaBinomialMix}(x, ...)

\method{summary}{betaMix}(object, probs = c(0.025, 0.5, 0.975), ...)

\method{summary}{betaBinomialMix}(object, probs = c(0.025, 0.5, 0.975), ...)
}
\arguments{
\item{...}{List of mixture components.}

\item{param}{Determines how the parameters in the list
are interpreted. See details.}

\item{m}{Vector of means of beta mixture components.}

\item{s}{Vector of standard deviations of beta mixture components.}

\item{drop}{Delete the dimensions of an array which have only one level.}

\item{n}{Vector of number of observations.}

\item{x}{The mixture to print}

\item{object}{Beta mixture object.}

\item{probs}{Quantiles reported by the \code{summary} function.}
}
\value{
\code{mixbeta} returns a beta mixture with the specified mixture components. \code{ms2beta} and
\code{mn2beta} return the equivalent natural \code{a} and \code{b} parametrization given parameters \code{m},
\code{s}, or \code{n}.
}
\description{
The Beta mixture density and auxilary functions.
}
\details{
Each entry in the \code{...} argument list is expected to
be a triplet of numbers which defines the weight \eqn{w_k}, first
and second parameter of the mixture component \eqn{k}. A triplet
can optionally be named which will be used appropriately.

The first and second parameter can be given in different
parametrizations which is set by the \code{param} option:
\describe{
\item{ab}{Natural parametrization of Beta density (\code{a}=shape1 and \code{b}=shape2). Default. }
\item{ms}{Mean and standard deviation, \eqn{m=a/(a+b)} and \eqn{s=\sqrt{\frac{m(1-m)}{1+n}}}, where \eqn{n=a+b} is the number of observations. Note that \eqn{s} must be less than \eqn{\sqrt{m(1-m)}}.}
\item{mn}{Mean and number of observations, \eqn{n=a+b}.}
}
}
\examples{
## a beta mixture
bm <- mixbeta(rob = c(0.2, 2, 10), inf = c(0.4, 10, 100), inf2 = c(0.4, 30, 80))

# mean/standard deviation parametrization
bm2 <- mixbeta(rob = c(0.2, 0.3, 0.2), inf = c(0.8, 0.4, 0.01), param = "ms")

# mean/observations parametrization
bm3 <- mixbeta(rob = c(0.2, 0.3, 5), inf = c(0.8, 0.4, 30), param = "mn")

# even mixed is possible
bm4 <- mixbeta(rob = c(0.2, mn2beta(0.3, 5)), inf = c(0.8, ms2beta(0.4, 0.1)))

# print methods are defined
bm4
print(bm4)

}
\seealso{
Other mixdist: 
\code{\link{mix}},
\code{\link{mixcombine}()},
\code{\link{mixgamma}()},
\code{\link{mixmvnorm}()},
\code{\link{mixnorm}()},
\code{\link{mixplot}}
}
\concept{mixdist}
