% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixcombine.R
\name{mixcombine}
\alias{mixcombine}
\title{Combine Mixture Distributions}
\usage{
mixcombine(..., weight, rescale = TRUE)
}
\arguments{
\item{...}{arbitrary number of mixtures with same distributional class.
Each component with values of mixture weight and model parameters.}

\item{weight}{relative weight for each component in new mixture
distribution. The vector must be of the same length as input
mixtures components. The default value gives equal weight to each
component.}

\item{rescale}{boolean value indicates if the weights are
rescaled to sum to 1.}
}
\value{
A R-object with the new mixture distribution.
}
\description{
Combining mixture distributions of the same class to form a new mixture.
}
\details{
Combines mixtures of the same class of random
variable to form a new mixture distribution.
}
\examples{
# beta with two informative components
bm <- mixbeta(inf=c(0.5, 10, 100), inf2=c(0.5, 30, 80))

# robustified with mixcombine, i.e. a 10\% uninformative part added
unif <- mixbeta(rob=c(1,1,1))
mixcombine(bm, unif, weight=c(9, 1))

}
\seealso{
\code{\link{robustify}}

Other mixdist: 
\code{\link{mixbeta}()},
\code{\link{mixgamma}()},
\code{\link{mixnorm}()},
\code{\link{mix}},
\code{\link{plot.mix}()}
}
\concept{mixdist}
