// Generated by rstantools.  Do not edit by hand.

/*
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.19.1
#include <stan/model/model_header.hpp>
namespace model_gMAP_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_gMAP");
    reader.add_event(0, 0, "include", "/include/license.stan");
    reader.add_event(0, 0, "start", "/include/license.stan");
    reader.add_event(9, 9, "end", "/include/license.stan");
    reader.add_event(9, 1, "restart", "model_gMAP");
    reader.add_event(9, 1, "include", "/include/copyright_novartis.stan");
    reader.add_event(9, 0, "start", "/include/copyright_novartis.stan");
    reader.add_event(11, 2, "end", "/include/copyright_novartis.stan");
    reader.add_event(11, 2, "restart", "model_gMAP");
    reader.add_event(218, 207, "end", "model_gMAP");
    return reader;
}
#include <stan_meta_header.hpp>
class model_gMAP : public prob_grad {
private:
        int H;
        int link;
        vector_d y;
        vector_d y_se;
        std::vector<int> r;
        std::vector<int> r_n;
        std::vector<int> count;
        vector_d log_offset;
        int n_groups;
        std::vector<int> group_index;
        int n_tau_strata;
        int tau_strata_pred;
        std::vector<int> tau_strata_index;
        int mX;
        matrix_d X;
        matrix_d beta_prior;
        matrix_d tau_prior;
        int tau_prior_dist;
        int re_dist;
        double re_dist_t_df;
        int ncp;
        std::vector<vector_d> beta_raw_guess;
        std::vector<double> tau_raw_guess;
        int prior_PD;
        std::vector<vector_d> beta_prior_stan;
        std::vector<vector_d> tau_prior_stan;
        matrix_d X_param;
        std::vector<int> tau_strata_gindex;
public:
    model_gMAP(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_gMAP(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_gMAP_namespace::model_gMAP";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 16;
            context__.validate_dims("data initialization", "H", "int", context__.to_vec());
            H = int(0);
            vals_i__ = context__.vals_i("H");
            pos__ = 0;
            H = vals_i__[pos__++];
            check_greater_or_equal(function__, "H", H, 1);
            current_statement_begin__ = 19;
            context__.validate_dims("data initialization", "link", "int", context__.to_vec());
            link = int(0);
            vals_i__ = context__.vals_i("link");
            pos__ = 0;
            link = vals_i__[pos__++];
            check_greater_or_equal(function__, "link", link, 1);
            check_less_or_equal(function__, "link", link, 3);
            current_statement_begin__ = 22;
            validate_non_negative_index("y", "H", H);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(H));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(H);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = H;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 23;
            validate_non_negative_index("y_se", "H", H);
            context__.validate_dims("data initialization", "y_se", "vector_d", context__.to_vec(H));
            y_se = Eigen::Matrix<double, Eigen::Dynamic, 1>(H);
            vals_r__ = context__.vals_r("y_se");
            pos__ = 0;
            size_t y_se_j_1_max__ = H;
            for (size_t j_1__ = 0; j_1__ < y_se_j_1_max__; ++j_1__) {
                y_se(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 26;
            validate_non_negative_index("r", "H", H);
            context__.validate_dims("data initialization", "r", "int", context__.to_vec(H));
            r = std::vector<int>(H, int(0));
            vals_i__ = context__.vals_i("r");
            pos__ = 0;
            size_t r_k_0_max__ = H;
            for (size_t k_0__ = 0; k_0__ < r_k_0_max__; ++k_0__) {
                r[k_0__] = vals_i__[pos__++];
            }
            size_t r_i_0_max__ = H;
            for (size_t i_0__ = 0; i_0__ < r_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "r[i_0__]", r[i_0__], 0);
            }
            current_statement_begin__ = 27;
            validate_non_negative_index("r_n", "H", H);
            context__.validate_dims("data initialization", "r_n", "int", context__.to_vec(H));
            r_n = std::vector<int>(H, int(0));
            vals_i__ = context__.vals_i("r_n");
            pos__ = 0;
            size_t r_n_k_0_max__ = H;
            for (size_t k_0__ = 0; k_0__ < r_n_k_0_max__; ++k_0__) {
                r_n[k_0__] = vals_i__[pos__++];
            }
            size_t r_n_i_0_max__ = H;
            for (size_t i_0__ = 0; i_0__ < r_n_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "r_n[i_0__]", r_n[i_0__], 1);
            }
            current_statement_begin__ = 30;
            validate_non_negative_index("count", "H", H);
            context__.validate_dims("data initialization", "count", "int", context__.to_vec(H));
            count = std::vector<int>(H, int(0));
            vals_i__ = context__.vals_i("count");
            pos__ = 0;
            size_t count_k_0_max__ = H;
            for (size_t k_0__ = 0; k_0__ < count_k_0_max__; ++k_0__) {
                count[k_0__] = vals_i__[pos__++];
            }
            size_t count_i_0_max__ = H;
            for (size_t i_0__ = 0; i_0__ < count_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "count[i_0__]", count[i_0__], 0);
            }
            current_statement_begin__ = 31;
            validate_non_negative_index("log_offset", "H", H);
            context__.validate_dims("data initialization", "log_offset", "vector_d", context__.to_vec(H));
            log_offset = Eigen::Matrix<double, Eigen::Dynamic, 1>(H);
            vals_r__ = context__.vals_r("log_offset");
            pos__ = 0;
            size_t log_offset_j_1_max__ = H;
            for (size_t j_1__ = 0; j_1__ < log_offset_j_1_max__; ++j_1__) {
                log_offset(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 34;
            context__.validate_dims("data initialization", "n_groups", "int", context__.to_vec());
            n_groups = int(0);
            vals_i__ = context__.vals_i("n_groups");
            pos__ = 0;
            n_groups = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_groups", n_groups, 1);
            current_statement_begin__ = 35;
            validate_non_negative_index("group_index", "H", H);
            context__.validate_dims("data initialization", "group_index", "int", context__.to_vec(H));
            group_index = std::vector<int>(H, int(0));
            vals_i__ = context__.vals_i("group_index");
            pos__ = 0;
            size_t group_index_k_0_max__ = H;
            for (size_t k_0__ = 0; k_0__ < group_index_k_0_max__; ++k_0__) {
                group_index[k_0__] = vals_i__[pos__++];
            }
            size_t group_index_i_0_max__ = H;
            for (size_t i_0__ = 0; i_0__ < group_index_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "group_index[i_0__]", group_index[i_0__], 1);
                check_less_or_equal(function__, "group_index[i_0__]", group_index[i_0__], n_groups);
            }
            current_statement_begin__ = 38;
            context__.validate_dims("data initialization", "n_tau_strata", "int", context__.to_vec());
            n_tau_strata = int(0);
            vals_i__ = context__.vals_i("n_tau_strata");
            pos__ = 0;
            n_tau_strata = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_tau_strata", n_tau_strata, 1);
            check_less_or_equal(function__, "n_tau_strata", n_tau_strata, n_groups);
            current_statement_begin__ = 39;
            context__.validate_dims("data initialization", "tau_strata_pred", "int", context__.to_vec());
            tau_strata_pred = int(0);
            vals_i__ = context__.vals_i("tau_strata_pred");
            pos__ = 0;
            tau_strata_pred = vals_i__[pos__++];
            check_greater_or_equal(function__, "tau_strata_pred", tau_strata_pred, 1);
            check_less_or_equal(function__, "tau_strata_pred", tau_strata_pred, n_tau_strata);
            current_statement_begin__ = 41;
            validate_non_negative_index("tau_strata_index", "H", H);
            context__.validate_dims("data initialization", "tau_strata_index", "int", context__.to_vec(H));
            tau_strata_index = std::vector<int>(H, int(0));
            vals_i__ = context__.vals_i("tau_strata_index");
            pos__ = 0;
            size_t tau_strata_index_k_0_max__ = H;
            for (size_t k_0__ = 0; k_0__ < tau_strata_index_k_0_max__; ++k_0__) {
                tau_strata_index[k_0__] = vals_i__[pos__++];
            }
            size_t tau_strata_index_i_0_max__ = H;
            for (size_t i_0__ = 0; i_0__ < tau_strata_index_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "tau_strata_index[i_0__]", tau_strata_index[i_0__], 1);
                check_less_or_equal(function__, "tau_strata_index[i_0__]", tau_strata_index[i_0__], n_tau_strata);
            }
            current_statement_begin__ = 44;
            context__.validate_dims("data initialization", "mX", "int", context__.to_vec());
            mX = int(0);
            vals_i__ = context__.vals_i("mX");
            pos__ = 0;
            mX = vals_i__[pos__++];
            check_greater_or_equal(function__, "mX", mX, 1);
            current_statement_begin__ = 46;
            validate_non_negative_index("X", "H", H);
            validate_non_negative_index("X", "mX", mX);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(H,mX));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(H, mX);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = mX;
            size_t X_j_1_max__ = H;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 52;
            validate_non_negative_index("beta_prior", "mX", mX);
            validate_non_negative_index("beta_prior", "2", 2);
            context__.validate_dims("data initialization", "beta_prior", "matrix_d", context__.to_vec(mX,2));
            beta_prior = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(mX, 2);
            vals_r__ = context__.vals_r("beta_prior");
            pos__ = 0;
            size_t beta_prior_j_2_max__ = 2;
            size_t beta_prior_j_1_max__ = mX;
            for (size_t j_2__ = 0; j_2__ < beta_prior_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < beta_prior_j_1_max__; ++j_1__) {
                    beta_prior(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 53;
            validate_non_negative_index("tau_prior", "n_tau_strata", n_tau_strata);
            validate_non_negative_index("tau_prior", "2", 2);
            context__.validate_dims("data initialization", "tau_prior", "matrix_d", context__.to_vec(n_tau_strata,2));
            tau_prior = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n_tau_strata, 2);
            vals_r__ = context__.vals_r("tau_prior");
            pos__ = 0;
            size_t tau_prior_j_2_max__ = 2;
            size_t tau_prior_j_1_max__ = n_tau_strata;
            for (size_t j_2__ = 0; j_2__ < tau_prior_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < tau_prior_j_1_max__; ++j_1__) {
                    tau_prior(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 56;
            context__.validate_dims("data initialization", "tau_prior_dist", "int", context__.to_vec());
            tau_prior_dist = int(0);
            vals_i__ = context__.vals_i("tau_prior_dist");
            pos__ = 0;
            tau_prior_dist = vals_i__[pos__++];
            check_greater_or_equal(function__, "tau_prior_dist", tau_prior_dist, -(1));
            check_less_or_equal(function__, "tau_prior_dist", tau_prior_dist, 7);
            current_statement_begin__ = 57;
            context__.validate_dims("data initialization", "re_dist", "int", context__.to_vec());
            re_dist = int(0);
            vals_i__ = context__.vals_i("re_dist");
            pos__ = 0;
            re_dist = vals_i__[pos__++];
            check_greater_or_equal(function__, "re_dist", re_dist, 0);
            check_less_or_equal(function__, "re_dist", re_dist, 1);
            current_statement_begin__ = 58;
            context__.validate_dims("data initialization", "re_dist_t_df", "double", context__.to_vec());
            re_dist_t_df = double(0);
            vals_r__ = context__.vals_r("re_dist_t_df");
            pos__ = 0;
            re_dist_t_df = vals_r__[pos__++];
            check_greater_or_equal(function__, "re_dist_t_df", re_dist_t_df, 0);
            current_statement_begin__ = 61;
            context__.validate_dims("data initialization", "ncp", "int", context__.to_vec());
            ncp = int(0);
            vals_i__ = context__.vals_i("ncp");
            pos__ = 0;
            ncp = vals_i__[pos__++];
            check_greater_or_equal(function__, "ncp", ncp, 0);
            check_less_or_equal(function__, "ncp", ncp, 1);
            current_statement_begin__ = 64;
            validate_non_negative_index("beta_raw_guess", "mX", mX);
            validate_non_negative_index("beta_raw_guess", "2", 2);
            context__.validate_dims("data initialization", "beta_raw_guess", "vector_d", context__.to_vec(2,mX));
            beta_raw_guess = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(2, Eigen::Matrix<double, Eigen::Dynamic, 1>(mX));
            vals_r__ = context__.vals_r("beta_raw_guess");
            pos__ = 0;
            size_t beta_raw_guess_j_1_max__ = mX;
            size_t beta_raw_guess_k_0_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < beta_raw_guess_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < beta_raw_guess_k_0_max__; ++k_0__) {
                    beta_raw_guess[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 65;
            validate_non_negative_index("tau_raw_guess", "2", 2);
            context__.validate_dims("data initialization", "tau_raw_guess", "double", context__.to_vec(2));
            tau_raw_guess = std::vector<double>(2, double(0));
            vals_r__ = context__.vals_r("tau_raw_guess");
            pos__ = 0;
            size_t tau_raw_guess_k_0_max__ = 2;
            for (size_t k_0__ = 0; k_0__ < tau_raw_guess_k_0_max__; ++k_0__) {
                tau_raw_guess[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 68;
            context__.validate_dims("data initialization", "prior_PD", "int", context__.to_vec());
            prior_PD = int(0);
            vals_i__ = context__.vals_i("prior_PD");
            pos__ = 0;
            prior_PD = vals_i__[pos__++];
            check_greater_or_equal(function__, "prior_PD", prior_PD, 0);
            check_less_or_equal(function__, "prior_PD", prior_PD, 1);
            // initialize transformed data variables
            current_statement_begin__ = 71;
            validate_non_negative_index("beta_prior_stan", "mX", mX);
            validate_non_negative_index("beta_prior_stan", "2", 2);
            beta_prior_stan = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(2, Eigen::Matrix<double, Eigen::Dynamic, 1>(mX));
            stan::math::fill(beta_prior_stan, DUMMY_VAR__);
            current_statement_begin__ = 72;
            validate_non_negative_index("tau_prior_stan", "n_tau_strata", n_tau_strata);
            validate_non_negative_index("tau_prior_stan", "2", 2);
            tau_prior_stan = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(2, Eigen::Matrix<double, Eigen::Dynamic, 1>(n_tau_strata));
            stan::math::fill(tau_prior_stan, DUMMY_VAR__);
            current_statement_begin__ = 75;
            validate_non_negative_index("X_param", "H", H);
            validate_non_negative_index("X_param", "mX", mX);
            X_param = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(H, mX);
            stan::math::fill(X_param, DUMMY_VAR__);
            current_statement_begin__ = 77;
            validate_non_negative_index("tau_strata_gindex", "n_groups", n_groups);
            tau_strata_gindex = std::vector<int>(n_groups, int(0));
            stan::math::fill(tau_strata_gindex, std::numeric_limits<int>::min());
            stan::math::assign(tau_strata_gindex,rep_array(tau_strata_pred, n_groups));
            // execute transformed data statements
            current_statement_begin__ = 79;
            for (int i = 1; i <= mX; ++i) {
                current_statement_begin__ = 80;
                stan::model::assign(beta_prior_stan, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                            get_base1(beta_prior, i, 1, "beta_prior", 1), 
                            "assigning variable beta_prior_stan");
                current_statement_begin__ = 81;
                stan::model::assign(beta_prior_stan, 
                            stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                            get_base1(beta_prior, i, 2, "beta_prior", 1), 
                            "assigning variable beta_prior_stan");
            }
            current_statement_begin__ = 84;
            for (int i = 1; i <= n_tau_strata; ++i) {
                current_statement_begin__ = 85;
                stan::model::assign(tau_prior_stan, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                            get_base1(tau_prior, i, 1, "tau_prior", 1), 
                            "assigning variable tau_prior_stan");
                current_statement_begin__ = 86;
                stan::model::assign(tau_prior_stan, 
                            stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                            get_base1(tau_prior, i, 2, "tau_prior", 1), 
                            "assigning variable tau_prior_stan");
            }
            current_statement_begin__ = 89;
            for (int i = 1; i <= H; ++i) {
                current_statement_begin__ = 90;
                stan::model::assign(tau_strata_gindex, 
                            stan::model::cons_list(stan::model::index_uni(get_base1(group_index, i, "group_index", 1)), stan::model::nil_index_list()), 
                            get_base1(tau_strata_index, i, "tau_strata_index", 1), 
                            "assigning variable tau_strata_gindex");
            }
            current_statement_begin__ = 105;
            if (pstream__) {
                stan_print(pstream__,"Stan gMAP analysis");
                *pstream__ << std::endl;
            }
            current_statement_begin__ = 107;
            if (as_bool(logical_eq(link, 1))) {
                current_statement_begin__ = 107;
                if (pstream__) {
                    stan_print(pstream__,"likelihood:      Normal (identity link)");
                    *pstream__ << std::endl;
                }
            }
            current_statement_begin__ = 108;
            if (as_bool(logical_eq(link, 2))) {
                current_statement_begin__ = 108;
                if (pstream__) {
                    stan_print(pstream__,"likelihood:      Binomial (logit link)");
                    *pstream__ << std::endl;
                }
            }
            current_statement_begin__ = 109;
            if (as_bool(logical_eq(link, 3))) {
                current_statement_begin__ = 109;
                if (pstream__) {
                    stan_print(pstream__,"likelihood:      Poisson (log link)");
                    *pstream__ << std::endl;
                }
            }
            current_statement_begin__ = 111;
            if (as_bool(logical_eq(tau_prior_dist, -(1)))) {
                current_statement_begin__ = 111;
                if (pstream__) {
                    stan_print(pstream__,"tau distrib.:    Fixed");
                    *pstream__ << std::endl;
                }
            }
            current_statement_begin__ = 112;
            if (as_bool(logical_eq(tau_prior_dist, 0))) {
                current_statement_begin__ = 112;
                if (pstream__) {
                    stan_print(pstream__,"tau distrib.:    HalfNormal");
                    *pstream__ << std::endl;
                }
            }
            current_statement_begin__ = 113;
            if (as_bool(logical_eq(tau_prior_dist, 1))) {
                current_statement_begin__ = 113;
                if (pstream__) {
                    stan_print(pstream__,"tau distrib.:    TruncNormal");
                    *pstream__ << std::endl;
                }
            }
            current_statement_begin__ = 114;
            if (as_bool(logical_eq(tau_prior_dist, 2))) {
                current_statement_begin__ = 114;
                if (pstream__) {
                    stan_print(pstream__,"tau distrib.:    Uniform");
                    *pstream__ << std::endl;
                }
            }
            current_statement_begin__ = 115;
            if (as_bool(logical_eq(tau_prior_dist, 3))) {
                current_statement_begin__ = 115;
                if (pstream__) {
                    stan_print(pstream__,"tau distrib.:    Gamma");
                    *pstream__ << std::endl;
                }
            }
            current_statement_begin__ = 116;
            if (as_bool(logical_eq(tau_prior_dist, 4))) {
                current_statement_begin__ = 116;
                if (pstream__) {
                    stan_print(pstream__,"tau distrib.:    InvGamma");
                    *pstream__ << std::endl;
                }
            }
            current_statement_begin__ = 117;
            if (as_bool(logical_eq(tau_prior_dist, 5))) {
                current_statement_begin__ = 117;
                if (pstream__) {
                    stan_print(pstream__,"tau distrib.:    LogNormal");
                    *pstream__ << std::endl;
                }
            }
            current_statement_begin__ = 118;
            if (as_bool(logical_eq(tau_prior_dist, 6))) {
                current_statement_begin__ = 118;
                if (pstream__) {
                    stan_print(pstream__,"tau distrib.:    TruncCauchy");
                    *pstream__ << std::endl;
                }
            }
            current_statement_begin__ = 119;
            if (as_bool(logical_eq(tau_prior_dist, 7))) {
                current_statement_begin__ = 119;
                if (pstream__) {
                    stan_print(pstream__,"tau distrib.:    Exponential");
                    *pstream__ << std::endl;
                }
            }
            current_statement_begin__ = 121;
            if (as_bool(logical_eq(re_dist, 0))) {
                current_statement_begin__ = 121;
                if (pstream__) {
                    stan_print(pstream__,"random effects:  Normal");
                    *pstream__ << std::endl;
                }
            }
            current_statement_begin__ = 122;
            if (as_bool(logical_eq(re_dist, 1))) {
                current_statement_begin__ = 122;
                if (pstream__) {
                    stan_print(pstream__,"random effects:  Student-t, df = ");
                    stan_print(pstream__,re_dist_t_df);
                    *pstream__ << std::endl;
                }
            }
            current_statement_begin__ = 124;
            if (as_bool(ncp)) {
                current_statement_begin__ = 125;
                stan::math::assign(X_param, X);
                current_statement_begin__ = 126;
                if (pstream__) {
                    stan_print(pstream__,"parametrization: Non-Centered");
                    *pstream__ << std::endl;
                }
            } else {
                current_statement_begin__ = 128;
                if (pstream__) {
                    stan_print(pstream__,"parametrization: Centered");
                    *pstream__ << std::endl;
                }
                current_statement_begin__ = 129;
                stan::math::assign(X_param, X);
                current_statement_begin__ = 130;
                for (int i = 1; i <= H; ++i) {
                    current_statement_begin__ = 131;
                    if (as_bool(logical_neq(get_base1(X_param, i, 1, "X_param", 1), 1))) {
                        current_statement_begin__ = 132;
                        std::stringstream errmsg_stream__;
                        errmsg_stream__ << "Centered parametrization requires treatment contrast parametrization!";
                        throw std::domain_error(errmsg_stream__.str());
                    }
                    current_statement_begin__ = 133;
                    stan::model::assign(X_param, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                0, 
                                "assigning variable X_param");
                }
            }
            current_statement_begin__ = 136;
            if (as_bool(prior_PD)) {
                current_statement_begin__ = 137;
                if (pstream__) {
                    stan_print(pstream__,"Info: Sampling from prior predictive distribution.");
                    *pstream__ << std::endl;
                }
            }
            // validate transformed data
            current_statement_begin__ = 77;
            size_t tau_strata_gindex_i_0_max__ = n_groups;
            for (size_t i_0__ = 0; i_0__ < tau_strata_gindex_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "tau_strata_gindex[i_0__]", tau_strata_gindex[i_0__], 1);
                check_less_or_equal(function__, "tau_strata_gindex[i_0__]", tau_strata_gindex[i_0__], n_tau_strata);
            }
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 140;
            validate_non_negative_index("beta_raw", "mX", mX);
            num_params_r__ += mX;
            current_statement_begin__ = 141;
            validate_non_negative_index("tau_raw", "n_tau_strata", n_tau_strata);
            num_params_r__ += n_tau_strata;
            current_statement_begin__ = 142;
            validate_non_negative_index("xi_eta", "n_groups", n_groups);
            num_params_r__ += n_groups;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_gMAP() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 140;
        if (!(context__.contains_r("beta_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta_raw");
        pos__ = 0U;
        validate_non_negative_index("beta_raw", "mX", mX);
        context__.validate_dims("parameter initialization", "beta_raw", "vector_d", context__.to_vec(mX));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta_raw(mX);
        size_t beta_raw_j_1_max__ = mX;
        for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
            beta_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 141;
        if (!(context__.contains_r("tau_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau_raw");
        pos__ = 0U;
        validate_non_negative_index("tau_raw", "n_tau_strata", n_tau_strata);
        context__.validate_dims("parameter initialization", "tau_raw", "vector_d", context__.to_vec(n_tau_strata));
        Eigen::Matrix<double, Eigen::Dynamic, 1> tau_raw(n_tau_strata);
        size_t tau_raw_j_1_max__ = n_tau_strata;
        for (size_t j_1__ = 0; j_1__ < tau_raw_j_1_max__; ++j_1__) {
            tau_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(tau_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 142;
        if (!(context__.contains_r("xi_eta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable xi_eta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("xi_eta");
        pos__ = 0U;
        validate_non_negative_index("xi_eta", "n_groups", n_groups);
        context__.validate_dims("parameter initialization", "xi_eta", "vector_d", context__.to_vec(n_groups));
        Eigen::Matrix<double, Eigen::Dynamic, 1> xi_eta(n_groups);
        size_t xi_eta_j_1_max__ = n_groups;
        for (size_t j_1__ = 0; j_1__ < xi_eta_j_1_max__; ++j_1__) {
            xi_eta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(xi_eta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable xi_eta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 140;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta_raw;
            (void) beta_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_raw = in__.vector_constrain(mX, lp__);
            else
                beta_raw = in__.vector_constrain(mX);
            current_statement_begin__ = 141;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tau_raw;
            (void) tau_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                tau_raw = in__.vector_constrain(n_tau_strata, lp__);
            else
                tau_raw = in__.vector_constrain(n_tau_strata);
            current_statement_begin__ = 142;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> xi_eta;
            (void) xi_eta;  // dummy to suppress unused var warning
            if (jacobian__)
                xi_eta = in__.vector_constrain(n_groups, lp__);
            else
                xi_eta = in__.vector_constrain(n_groups);
            // transformed parameters
            current_statement_begin__ = 145;
            validate_non_negative_index("theta", "H", H);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta(H);
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            current_statement_begin__ = 146;
            validate_non_negative_index("eta", "n_groups", n_groups);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta(n_groups);
            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta, DUMMY_VAR__);
            current_statement_begin__ = 147;
            validate_non_negative_index("beta", "mX", mX);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta(mX);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 148;
            validate_non_negative_index("tau", "n_tau_strata", n_tau_strata);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tau(n_tau_strata);
            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau, DUMMY_VAR__);
            current_statement_begin__ = 149;
            validate_non_negative_index("tau_group", "n_groups", n_groups);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tau_group(n_groups);
            stan::math::initialize(tau_group, DUMMY_VAR__);
            stan::math::fill(tau_group, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 151;
            stan::math::assign(beta, add(get_base1(beta_raw_guess, 1, "beta_raw_guess", 1), elt_multiply(get_base1(beta_raw_guess, 2, "beta_raw_guess", 1), beta_raw)));
            current_statement_begin__ = 154;
            if (as_bool(logical_eq(tau_prior_dist, -(1)))) {
                current_statement_begin__ = 155;
                stan::math::assign(tau, get_base1(tau_prior_stan, 1, "tau_prior_stan", 1));
            } else {
                current_statement_begin__ = 157;
                stan::math::assign(tau, stan::math::exp(add(get_base1(tau_raw_guess, 1, "tau_raw_guess", 1), multiply(get_base1(tau_raw_guess, 2, "tau_raw_guess", 1), tau_raw))));
            }
            current_statement_begin__ = 159;
            stan::math::assign(tau_group, stan::model::rvalue(tau, stan::model::cons_list(stan::model::index_multi(tau_strata_gindex), stan::model::nil_index_list()), "tau"));
            current_statement_begin__ = 161;
            if (as_bool(ncp)) {
                current_statement_begin__ = 162;
                stan::math::assign(eta, elt_multiply(xi_eta, tau_group));
            } else {
                current_statement_begin__ = 164;
                stan::math::assign(eta, add(get_base1(get_base1(beta_raw_guess, 1, "beta_raw_guess", 1), 1, "beta_raw_guess", 2), multiply(get_base1(get_base1(beta_raw_guess, 2, "beta_raw_guess", 1), 1, "beta_raw_guess", 2), xi_eta)));
            }
            current_statement_begin__ = 166;
            stan::math::assign(theta, add(multiply(X_param, beta), stan::model::rvalue(eta, stan::model::cons_list(stan::model::index_multi(group_index), stan::model::nil_index_list()), "eta")));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 145;
            size_t theta_j_1_max__ = H;
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(theta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 146;
            size_t eta_j_1_max__ = n_groups;
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(eta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: eta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 147;
            size_t beta_j_1_max__ = mX;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(beta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 148;
            size_t tau_j_1_max__ = n_tau_strata;
            for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(tau(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: tau" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable tau: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 149;
            size_t tau_group_j_1_max__ = n_groups;
            for (size_t j_1__ = 0; j_1__ < tau_group_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(tau_group(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: tau_group" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable tau_group: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 169;
            if (as_bool(ncp)) {
                current_statement_begin__ = 171;
                if (as_bool(logical_eq(re_dist, 0))) {
                    current_statement_begin__ = 171;
                    lp_accum__.add(normal_log<propto__>(xi_eta, 0, 1));
                }
                current_statement_begin__ = 172;
                if (as_bool(logical_eq(re_dist, 1))) {
                    current_statement_begin__ = 172;
                    lp_accum__.add(student_t_log<propto__>(xi_eta, re_dist_t_df, 0, 1));
                }
            } else {
                current_statement_begin__ = 175;
                if (as_bool(logical_eq(re_dist, 0))) {
                    current_statement_begin__ = 175;
                    lp_accum__.add(normal_log<propto__>(xi_eta, ((get_base1(beta, 1, "beta", 1) - get_base1(get_base1(beta_raw_guess, 1, "beta_raw_guess", 1), 1, "beta_raw_guess", 2)) / get_base1(get_base1(beta_raw_guess, 2, "beta_raw_guess", 1), 1, "beta_raw_guess", 2)), divide(tau_group, get_base1(get_base1(beta_raw_guess, 2, "beta_raw_guess", 1), 1, "beta_raw_guess", 2))));
                }
                current_statement_begin__ = 176;
                if (as_bool(logical_eq(re_dist, 1))) {
                    current_statement_begin__ = 176;
                    lp_accum__.add(student_t_log<propto__>(xi_eta, re_dist_t_df, ((get_base1(beta, 1, "beta", 1) - get_base1(get_base1(beta_raw_guess, 1, "beta_raw_guess", 1), 1, "beta_raw_guess", 2)) / get_base1(get_base1(beta_raw_guess, 2, "beta_raw_guess", 1), 1, "beta_raw_guess", 2)), divide(tau_group, get_base1(get_base1(beta_raw_guess, 2, "beta_raw_guess", 1), 1, "beta_raw_guess", 2))));
                }
            }
            current_statement_begin__ = 180;
            lp_accum__.add(normal_log<propto__>(beta, get_base1(beta_prior_stan, 1, "beta_prior_stan", 1), get_base1(beta_prior_stan, 2, "beta_prior_stan", 1)));
            current_statement_begin__ = 183;
            if (as_bool(logical_eq(tau_prior_dist, -(1)))) {
                current_statement_begin__ = 183;
                lp_accum__.add(normal_log<propto__>(tau_raw, 0, 1));
            }
            current_statement_begin__ = 185;
            if (as_bool(logical_eq(tau_prior_dist, 0))) {
                current_statement_begin__ = 185;
                lp_accum__.add(normal_log<propto__>(tau, 0, get_base1(tau_prior_stan, 2, "tau_prior_stan", 1)));
            }
            current_statement_begin__ = 187;
            if (as_bool(logical_eq(tau_prior_dist, 1))) {
                current_statement_begin__ = 187;
                lp_accum__.add(normal_log<propto__>(tau, get_base1(tau_prior_stan, 1, "tau_prior_stan", 1), get_base1(tau_prior_stan, 2, "tau_prior_stan", 1)));
            }
            current_statement_begin__ = 188;
            if (as_bool(logical_eq(tau_prior_dist, 2))) {
                current_statement_begin__ = 188;
                lp_accum__.add(uniform_log<propto__>(tau, get_base1(tau_prior_stan, 1, "tau_prior_stan", 1), get_base1(tau_prior_stan, 2, "tau_prior_stan", 1)));
            }
            current_statement_begin__ = 189;
            if (as_bool(logical_eq(tau_prior_dist, 3))) {
                current_statement_begin__ = 189;
                lp_accum__.add(gamma_log<propto__>(tau, get_base1(tau_prior_stan, 1, "tau_prior_stan", 1), get_base1(tau_prior_stan, 2, "tau_prior_stan", 1)));
            }
            current_statement_begin__ = 190;
            if (as_bool(logical_eq(tau_prior_dist, 4))) {
                current_statement_begin__ = 190;
                lp_accum__.add(inv_gamma_log<propto__>(tau, get_base1(tau_prior_stan, 1, "tau_prior_stan", 1), get_base1(tau_prior_stan, 2, "tau_prior_stan", 1)));
            }
            current_statement_begin__ = 191;
            if (as_bool(logical_eq(tau_prior_dist, 5))) {
                current_statement_begin__ = 191;
                lp_accum__.add(lognormal_log<propto__>(tau, get_base1(tau_prior_stan, 1, "tau_prior_stan", 1), get_base1(tau_prior_stan, 2, "tau_prior_stan", 1)));
            }
            current_statement_begin__ = 192;
            if (as_bool(logical_eq(tau_prior_dist, 6))) {
                current_statement_begin__ = 192;
                lp_accum__.add(cauchy_log<propto__>(tau, get_base1(tau_prior_stan, 1, "tau_prior_stan", 1), get_base1(tau_prior_stan, 2, "tau_prior_stan", 1)));
            }
            current_statement_begin__ = 193;
            if (as_bool(logical_eq(tau_prior_dist, 7))) {
                current_statement_begin__ = 193;
                lp_accum__.add(exponential_log<propto__>(tau, get_base1(tau_prior_stan, 1, "tau_prior_stan", 1)));
            }
            current_statement_begin__ = 196;
            if (as_bool(logical_neq(tau_prior_dist, -(1)))) {
                current_statement_begin__ = 196;
                lp_accum__.add(multiply(get_base1(tau_raw_guess, 2, "tau_raw_guess", 1), tau_raw));
            }
            current_statement_begin__ = 199;
            if (as_bool(logical_negation(prior_PD))) {
                current_statement_begin__ = 200;
                if (as_bool(logical_eq(link, 1))) {
                    current_statement_begin__ = 200;
                    lp_accum__.add(normal_log<propto__>(y, theta, y_se));
                }
                current_statement_begin__ = 201;
                if (as_bool(logical_eq(link, 2))) {
                    current_statement_begin__ = 201;
                    lp_accum__.add(binomial_logit_log<propto__>(r, r_n, theta));
                }
                current_statement_begin__ = 202;
                if (as_bool(logical_eq(link, 3))) {
                    current_statement_begin__ = 202;
                    lp_accum__.add(poisson_log_log<propto__>(count, add(log_offset, theta)));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta_raw");
        names__.push_back("tau_raw");
        names__.push_back("xi_eta");
        names__.push_back("theta");
        names__.push_back("eta");
        names__.push_back("beta");
        names__.push_back("tau");
        names__.push_back("tau_group");
        names__.push_back("theta_pred");
        names__.push_back("theta_resp_pred");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(mX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_tau_strata);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_groups);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(H);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_groups);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(mX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_tau_strata);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_groups);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_gMAP_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta_raw = in__.vector_constrain(mX);
        size_t beta_raw_j_1_max__ = mX;
        for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
            vars__.push_back(beta_raw(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> tau_raw = in__.vector_constrain(n_tau_strata);
        size_t tau_raw_j_1_max__ = n_tau_strata;
        for (size_t j_1__ = 0; j_1__ < tau_raw_j_1_max__; ++j_1__) {
            vars__.push_back(tau_raw(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> xi_eta = in__.vector_constrain(n_groups);
        size_t xi_eta_j_1_max__ = n_groups;
        for (size_t j_1__ = 0; j_1__ < xi_eta_j_1_max__; ++j_1__) {
            vars__.push_back(xi_eta(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 145;
            validate_non_negative_index("theta", "H", H);
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta(H);
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            current_statement_begin__ = 146;
            validate_non_negative_index("eta", "n_groups", n_groups);
            Eigen::Matrix<double, Eigen::Dynamic, 1> eta(n_groups);
            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta, DUMMY_VAR__);
            current_statement_begin__ = 147;
            validate_non_negative_index("beta", "mX", mX);
            Eigen::Matrix<double, Eigen::Dynamic, 1> beta(mX);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 148;
            validate_non_negative_index("tau", "n_tau_strata", n_tau_strata);
            Eigen::Matrix<double, Eigen::Dynamic, 1> tau(n_tau_strata);
            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau, DUMMY_VAR__);
            current_statement_begin__ = 149;
            validate_non_negative_index("tau_group", "n_groups", n_groups);
            Eigen::Matrix<double, Eigen::Dynamic, 1> tau_group(n_groups);
            stan::math::initialize(tau_group, DUMMY_VAR__);
            stan::math::fill(tau_group, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 151;
            stan::math::assign(beta, add(get_base1(beta_raw_guess, 1, "beta_raw_guess", 1), elt_multiply(get_base1(beta_raw_guess, 2, "beta_raw_guess", 1), beta_raw)));
            current_statement_begin__ = 154;
            if (as_bool(logical_eq(tau_prior_dist, -(1)))) {
                current_statement_begin__ = 155;
                stan::math::assign(tau, get_base1(tau_prior_stan, 1, "tau_prior_stan", 1));
            } else {
                current_statement_begin__ = 157;
                stan::math::assign(tau, stan::math::exp(add(get_base1(tau_raw_guess, 1, "tau_raw_guess", 1), multiply(get_base1(tau_raw_guess, 2, "tau_raw_guess", 1), tau_raw))));
            }
            current_statement_begin__ = 159;
            stan::math::assign(tau_group, stan::model::rvalue(tau, stan::model::cons_list(stan::model::index_multi(tau_strata_gindex), stan::model::nil_index_list()), "tau"));
            current_statement_begin__ = 161;
            if (as_bool(ncp)) {
                current_statement_begin__ = 162;
                stan::math::assign(eta, elt_multiply(xi_eta, tau_group));
            } else {
                current_statement_begin__ = 164;
                stan::math::assign(eta, add(get_base1(get_base1(beta_raw_guess, 1, "beta_raw_guess", 1), 1, "beta_raw_guess", 2), multiply(get_base1(get_base1(beta_raw_guess, 2, "beta_raw_guess", 1), 1, "beta_raw_guess", 2), xi_eta)));
            }
            current_statement_begin__ = 166;
            stan::math::assign(theta, add(multiply(X_param, beta), stan::model::rvalue(eta, stan::model::cons_list(stan::model::index_multi(group_index), stan::model::nil_index_list()), "eta")));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t theta_j_1_max__ = H;
                for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                    vars__.push_back(theta(j_1__));
                }
                size_t eta_j_1_max__ = n_groups;
                for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                    vars__.push_back(eta(j_1__));
                }
                size_t beta_j_1_max__ = mX;
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    vars__.push_back(beta(j_1__));
                }
                size_t tau_j_1_max__ = n_tau_strata;
                for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                    vars__.push_back(tau(j_1__));
                }
                size_t tau_group_j_1_max__ = n_groups;
                for (size_t j_1__ = 0; j_1__ < tau_group_j_1_max__; ++j_1__) {
                    vars__.push_back(tau_group(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 206;
            double theta_pred;
            (void) theta_pred;  // dummy to suppress unused var warning
            stan::math::initialize(theta_pred, DUMMY_VAR__);
            stan::math::fill(theta_pred, DUMMY_VAR__);
            current_statement_begin__ = 207;
            double theta_resp_pred;
            (void) theta_resp_pred;  // dummy to suppress unused var warning
            stan::math::initialize(theta_resp_pred, DUMMY_VAR__);
            stan::math::fill(theta_resp_pred, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 210;
            if (as_bool(logical_eq(re_dist, 0))) {
                current_statement_begin__ = 210;
                stan::math::assign(theta_pred, normal_rng(get_base1(beta, 1, "beta", 1), get_base1(tau, tau_strata_pred, "tau", 1), base_rng__));
            }
            current_statement_begin__ = 211;
            if (as_bool(logical_eq(re_dist, 1))) {
                current_statement_begin__ = 211;
                stan::math::assign(theta_pred, student_t_rng(re_dist_t_df, get_base1(beta, 1, "beta", 1), get_base1(tau, tau_strata_pred, "tau", 1), base_rng__));
            }
            current_statement_begin__ = 213;
            if (as_bool(logical_eq(link, 1))) {
                current_statement_begin__ = 213;
                stan::math::assign(theta_resp_pred, theta_pred);
            }
            current_statement_begin__ = 214;
            if (as_bool(logical_eq(link, 2))) {
                current_statement_begin__ = 214;
                stan::math::assign(theta_resp_pred, inv_logit(theta_pred));
            }
            current_statement_begin__ = 215;
            if (as_bool(logical_eq(link, 3))) {
                current_statement_begin__ = 215;
                stan::math::assign(theta_resp_pred, stan::math::exp(theta_pred));
            }
            // validate, write generated quantities
            current_statement_begin__ = 206;
            vars__.push_back(theta_pred);
            current_statement_begin__ = 207;
            vars__.push_back(theta_resp_pred);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    static std::string model_name() {
        return "model_gMAP";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_raw_j_1_max__ = mX;
        for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_raw_j_1_max__ = n_tau_strata;
        for (size_t j_1__ = 0; j_1__ < tau_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t xi_eta_j_1_max__ = n_groups;
        for (size_t j_1__ = 0; j_1__ < xi_eta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_eta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t theta_j_1_max__ = H;
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t eta_j_1_max__ = n_groups;
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t beta_j_1_max__ = mX;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t tau_j_1_max__ = n_tau_strata;
            for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t tau_group_j_1_max__ = n_groups;
            for (size_t j_1__ = 0; j_1__ < tau_group_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau_group" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "theta_pred";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "theta_resp_pred";
        param_names__.push_back(param_name_stream__.str());
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_raw_j_1_max__ = mX;
        for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_raw_j_1_max__ = n_tau_strata;
        for (size_t j_1__ = 0; j_1__ < tau_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t xi_eta_j_1_max__ = n_groups;
        for (size_t j_1__ = 0; j_1__ < xi_eta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_eta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t theta_j_1_max__ = H;
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t eta_j_1_max__ = n_groups;
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t beta_j_1_max__ = mX;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t tau_j_1_max__ = n_tau_strata;
            for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t tau_group_j_1_max__ = n_groups;
            for (size_t j_1__ = 0; j_1__ < tau_group_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau_group" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "theta_pred";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "theta_resp_pred";
        param_names__.push_back(param_name_stream__.str());
    }
}; // model
}  // namespace
typedef model_gMAP_namespace::model_gMAP stan_model;
#endif
