% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBMRB.R
\name{chemical_shift_hists}
\alias{chemical_shift_hists}
\title{Plots chemical shift distribution for a list of atoms}
\usage{
chemical_shift_hists(atm = NA, type = "count", bw = 0.1, cutoff = 8,
  interactive = TRUE)
}
\arguments{
\item{atm}{list Example: c("ALA-CA","GLY-CA")}

\item{type}{count ; other than count will assume density plot}

\item{bw}{binwith for histogram; default value 0.1ppm}

\item{cutoff}{values not with in the cutoff time standard deviation from both sides ofthe mean will be excluded from the plot;default value 8}

\item{interactive}{TRUE/FALSE default TRUE}
}
\value{
R plot object
}
\description{
Plots the histogram (or) density of  chemical shift distribution of a given list of atoms. Atoms from different residues cam be specified as "residue-atom". Exammple "ALA-CA","GLN-HE21","GLN-HE*"
}
\examples{
#plt<-chemical_shift_hists(c('ALA-C*'))
#plots the histogram of all atoms of ALA
#plt<-chemical_shift_hists(c("GLY-H*","ALA-HA"),type='density')
#plots the density plot
}
\seealso{
\code{\link{fetch_res_chemical_shifts}},\code{\link{filter_residue}} and \code{\link{chemical_shift_corr}}
}

