% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlimits.R
\name{rlimit_as}
\alias{rlimit_as}
\alias{rlimit_core}
\alias{rlimit_cpu}
\alias{rlimit_data}
\alias{rlimit_fsize}
\alias{rlimit_memlock}
\alias{rlimit_msgqueue}
\alias{rlimit_nice}
\alias{rlimit_nofile}
\alias{rlimit_nproc}
\alias{rlimit_rtprio}
\alias{rlimit_rttime}
\alias{rlimit_sigpending}
\alias{rlimit_stack}
\title{Resource Limits}
\usage{
rlimit_as(hardlim = NULL, softlim = hardlim, pid = 0, verbose = FALSE)

rlimit_core(hardlim = NULL, softlim = hardlim, pid = 0, verbose = FALSE)

rlimit_cpu(hardlim = NULL, softlim = hardlim, pid = 0, verbose = FALSE)

rlimit_data(hardlim = NULL, softlim = hardlim, pid = 0, verbose = FALSE)

rlimit_fsize(hardlim = NULL, softlim = hardlim, pid = 0,
  verbose = FALSE)

rlimit_memlock(hardlim = NULL, softlim = hardlim, pid = 0,
  verbose = FALSE)

rlimit_msgqueue(hardlim = NULL, softlim = hardlim, pid = 0,
  verbose = FALSE)

rlimit_nice(hardlim = NULL, softlim = hardlim, pid = 0, verbose = FALSE)

rlimit_nofile(hardlim = NULL, softlim = hardlim, pid = 0,
  verbose = FALSE)

rlimit_nproc(hardlim = NULL, softlim = hardlim, pid = 0,
  verbose = FALSE)

rlimit_rtprio(hardlim = NULL, softlim = hardlim, pid = 0,
  verbose = FALSE)

rlimit_rttime(hardlim = NULL, softlim = hardlim, pid = 0,
  verbose = FALSE)

rlimit_sigpending(hardlim = NULL, softlim = hardlim, pid = 0,
  verbose = FALSE)

rlimit_stack(hardlim = NULL, softlim = hardlim, pid = 0,
  verbose = FALSE)
}
\arguments{
\item{hardlim}{hard limit in bytes}

\item{softlim}{soft limit in bytes.}

\item{pid}{id of the target process.}

\item{verbose}{print some C output (TRUE/FALSE)}
}
\description{
Get and set \href{http://linux.die.net/man/2/setrlimit}{RLIMIT}
values of the current process.
}
\examples{
\dontrun{
#load lib
library(RAppArmor)

#current limit
rlimit_as();

#set hard limit
rlimit_as(1e9);

#set separate hard and soft limit. 
rlimit_as(1e9, 1e8);

#soft limits can be elevated
rlimit_as(soft = 1e7);
rlimit_as(soft = 1e9);

#set other limits
rlimit_core(1e9);
rlimit_data(1e9);
rlimit_fsize(1e9);
rlimit_memlock(10000);
rlimit_msgqueue(1e5);
rlimit_nofile(10);
rlimit_nproc(100);
rlimit_rttime(1e9);
rlimit_sigpending(1e4);
rlimit_stack(1000);
rlimit_cpu(60);
}
\dontrun{testfun <- function(){
  Sys.sleep(3);
  repeat{
    svd(matrix(rnorm(1e6,1e3)));
  }
};
#will be killed after 8 seconds (3s idle, 5s CPU):
system.time(eval.secure(testfun(), RLIMIT_CPU=5));

#will be killed after 5 seconds
system.time(eval.secure(testfun(), timeout=5));}
}
\references{
Jeroen Ooms (2013). The RAppArmor Package: Enforcing Security Policies in {R} Using Dynamic Sandboxing on Linux. \emph{Journal of Statistical Software}, 55(7), 1-34. \url{http://www.jstatsoft.org/v55/i07/}.

Ubuntu Manpage: \code{getrlimit, setrlimit} - \emph{get/set resource limits}. \url{http://manpages.ubuntu.com/manpages/precise/man2/getrlimit.2.html}.
}

