% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AQSAPI.R
\name{aqs_fields_by_service}
\alias{aqs_fields_by_service}
\title{aqs_fieldsbyservice}
\usage{
aqs_fields_by_service(service, return_header = FALSE)
}
\arguments{
\item{service}{a string which represents the services provided by the AQS
API. For a list of available services
@seealso \url{https://aqs.epa.gov/aqsweb/documents/data_api.html#services
                  }}

\item{return_header}{If FALSE (default) only returns data requested.
If TRUE returns a AQSAPI_v2 object which is a two
item list that contains header information returned
from the API server mostly used for debugging
purposes in addition to the data requested.}
}
\value{
a tibble or an AQS_Data Mart_APIv2 S3 object with containing the list
and definitions of fields requested service
}
\description{
\lifecycle{stable}
Returns a tibble or an AQS_Data Mart_APIv2 S3
object with the list and definitions of fields in the
service requested.
}
\examples{
# Returns a tibble containing a list and definitions
         #  of fields in the Sample Data service
         \dontrun{fields_by_service(service = "list")}

}
