% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc.cmpd.get.classyfire.R
\name{rc.cmpd.get.classyfire}
\alias{rc.cmpd.get.classyfire}
\title{getClassyFire}
\usage{
rc.cmpd.get.classyfire(
  ramclustObj = NULL,
  inchikey = NULL,
  get.all = TRUE,
  max.wait = 10,
  posts.per.minute = 5
)
}
\arguments{
\item{ramclustObj}{ramclustR object to ClassyFy.  Must supply one of either ramclustObj or inchikey (see below)}

\item{inchikey}{vector of text inchikeys to ClassyFy.  Must supply one of either ramclustObj or inchikey.}

\item{get.all}{logical; if TRUE, when inchikey classyfire lookup fails, submits for classyfication.  Can be slow. max.wait (below) sets max time to spend on each compound before moving on. default = FALSE.}

\item{max.wait}{numeric; maximum time (seconds) to wait per compound when 'get.all' = TRUE.}

\item{posts.per.minute}{integer; a limit set when 'get.all' is true.  ClassyFire server accepts no more than 5 posts per minute when calculating new ClassyFire results.  Slows down submission process to keep server from denying access.}
}
\value{
returns a ramclustR object.  new dataframe in $classyfire slot with rows equal to number of compounds.
}
\description{
use classyfire web API to look up full ClassyFire hirarchy for each inchikey
}
\details{
The $inchikey slot is used to look up the
}
\references{
Djoumbou Feunang Y, Eisner R, Knox C, Chepelev L, Hastings J, Owen G, Fahy E, Steinbeck C, Subramanian S, Bolton E, Greiner R, and Wishart DS. ClassyFire: Automated Chemical Classification With A Comprehensive, Computable Taxonomy. Journal of Cheminformatics, 2016, 8:61. DOI: 10.1186/s13321-016-0174-y
}
\author{
Corey Broeckling
}
\concept{MSFinder}
\concept{RAMClustR}
\concept{classyFire}
\concept{clustering}
\concept{feature}
\concept{mass spectrometry}
\concept{metabolomics}
\concept{ramclustR}
\concept{xcms}
