% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc.get.xmcs.data.R
\name{rc.get.xcms.data}
\alias{rc.get.xcms.data}
\title{rc.get.xcms.data}
\usage{
rc.get.xcms.data(
  xcmsObj = NULL,
  taglocation = "filepaths",
  MStag = NULL,
  MSMStag = NULL,
  ExpDes = NULL,
  mzdec = 3,
  ensure.no.na = TRUE
)
}
\arguments{
\item{xcmsObj}{xcmsObject: containing grouped feature data for clustering by ramclustR}

\item{taglocation}{character: "filepaths" by default, "phenoData[,1]" is another option. refers to xcms slot}

\item{MStag}{character: character string in 'taglocation' to designate files as either MS / DIA(MSe, MSall, AIF, etc) e.g. "01.mzML"}

\item{MSMStag}{character: character string in 'taglocation' to designate files as either MS / DIA(MSe, MSall, AIF, etc) e.g. "02.mzML"}

\item{ExpDes}{either an R object created by R ExpDes object: data used for record keeping and labelling msp spectral output}

\item{mzdec}{integer: number of decimal places for storing m/z values}

\item{ensure.no.na}{logical: if TRUE, any 'NA' values in msint and/or msmsint are replaced with numerical values based on 10 percent of feature min plus noise.  Used to ensure that spectra are not written with NA values.}
}
\value{
an empty ramclustR object.  this object is formatted as an hclust object with additional slots for holding feature and compound data. details on these found below.

$frt: feature retention time, in whatever units were fed in (xcms uses seconds, by default)

$fmz: feature retention time, reported in number of decimal points selected in ramclustR function

$ExpDes: the experimental design object used when running ramclustR.  List of two dataframes.

$MSdata:  the MSdataset provided by either xcms or csv input

$MSMSdata: the (optional) DIA(MSe, MSall, AIF etc) dataset provided be either xcms or csv input

$xcmsOrd: original xcms order of features, for back-referencing when necessary

$msint: weighted.mean intensity of feature in ms level data

$msmsint:weighted.mean intensity of feature in msms level data
}
\description{
extractor for xcms objects in preparation for normalization and clustering
}
\details{
This function creates a ramclustObj which will be used as input for clustering.
}
\references{
Broeckling CD, Afsar FA, Neumann S, Ben-Hur A, Prenni JE. RAMClust: a novel feature clustering method enables spectral-matching-based annotation for metabolomics data. Anal Chem. 2014 Jul 15;86(14):6812-7. doi: 10.1021/ac501530d.  Epub 2014 Jun 26. PubMed PMID: 24927477.

Broeckling CD, Ganna A, Layer M, Brown K, Sutton B, Ingelsson E, Peers G, Prenni JE. Enabling Efficient and Confident Annotation of LC-MS Metabolomics Data through MS1 Spectrum and Time Prediction. Anal Chem. 2016 Sep 20;88(18):9226-34. doi: 10.1021/acs.analchem.6b02479. Epub 2016 Sep 8. PubMed PMID: 7560453.
}
\author{
Corey Broeckling
}
\concept{MSFinder}
\concept{RAMClustR}
\concept{clustering}
\concept{feature}
\concept{mass spectrometry}
\concept{metabolomics}
\concept{ramclustR}
\concept{xcms}
