% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsa.convert.data2.r
\name{lsa.convert.data2}
\alias{lsa.convert.data2}
\title{Convert Large-Scale Assessments' Datasets to .RData Format}
\usage{
lsa.convert.data2(
  inp.folder,
  PISApre15 = FALSE,
  ISO,
  missing.to.NA = FALSE,
  out.folder
)
}
\arguments{
\item{inp.folder}{The folder containing the IEA-like SPSS data files or ASCII text files and
\code{.sps} import files for OECD PISA data from cycles prior to 2015.
See details.
If blank, the working directory (\code{getwd()}) is used.}

\item{PISApre15}{When converting PISA files, set to \code{TRUE} if the input files are from
PISA cycles prior 2015 (ASCII text format with \code{.sps} control files)
or to \code{FALSE} (default) if they are in SPSS \code{.sav} format, as in
the case of IEA studies and the like and OECD PISA 2015 or later. Ignored
if the input folder contains IEA-like studies.}

\item{ISO}{Vector containing character ISO codes of the countries' data files to
convert (e.g. \code{ISO = c("aus", "svn")}). If none of the files contain
the specified ISO codes in their names, the codes are ignored and a warning
is shown. Ignored when converting PISA files (both for cycles prior 2015
and 2015 and later). This argument is case-insensitive, i.e. the ISO codes
can be passed as lower- or upper-case.
(lower or upper) as the original SPSS \code{.sav} files.}

\item{missing.to.NA}{Should the user-defined missing values be recoded to \code{NA}? If
\code{TRUE}, all user-defined missing values from the SPSS files (or
specified in the OECD PISA import syntax files) are all imported as
\code{NA}. If \code{FALSE} (default), they are converted to valid values
and the missing codes are assigned to an attribute \code{missings} for
each variable. See details.}

\item{out.folder}{Path to the folder where the converted files will be stored. If omitted,
same as the \code{inp.folder}, and if the \code{inp.folder} is missing as
well, this will be \code{getwd()}.}
}
\value{
See the "Value" section of the \code{lsa.convert.data}.
}
\description{
\code{lsa.convert.data2} is a deprecated version of of the \code{lsa.convert.data} function using a different approach. It is an old version of the \code{lsa.convert.data} function and will be removed from the package in June of 2025. Use only if you experience issues with \code{lsa.convert.data}.
}
\details{
See the details of \code{lsa.convert.data}.
}
\note{
See the "Notes" section of \code{lsa.convert.data}.
}
\examples{
# See the examples of \code{lsa.convert.data}.

}
\references{
Foy, P. (Ed.). (2018). \emph{PIRLS 2016 User Guide for the International Database}. TIMSS & PIRLS International Study Center.
}
\seealso{
\code{\link{lsa.convert.data2}}, \code{\link{lsa.merge.data}}, \code{\link{lsa.vars.dict}}, \code{\link{lsa.recode.vars}}
}
