% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc_var.r
\name{auc_var}
\alias{auc_var}
\title{auc_var function}
\usage{
auc_var(dat, v1, nv, kv)
}
\arguments{
\item{dat}{N by (M+1) matrix having variables in the order of cbind(y,x)}

\item{v1}{This can be set as v1=c(1), v1=c(1,2) or possibly with more values}

\item{nv}{Sample size}

\item{kv}{Population prevalence}
}
\value{
This function will test the null hypothesis for AUC. To get the test statistics for AUC(y~x[,v1]). The outputs are listed as follows.
\item{auc}{AUC}
\item{var}{Variance of AUC}
\item{upper_auc}{Upper limit of 95\% CI for AUC}
\item{lower_auc}{Lower limit of 95\% CI for AUC}
}
\description{
This function estimates var(AUC(y~x[,v1]))
where AUC is the Area Under ROC curve of the model,
y is N by 1 matrix having the dependent variable, and
x is N by M matrix having M explanatory variables.
v1 indicates the ith column in the x matrix
(v1 can be multiple values between 1 - M, see Arguments below)
}
\examples{
#To get the AUC for AUC(y=x[,v1]) 

dat=dat1 #(this example embedded within the package)
nv=length(dat$V1)
kv=sum(dat$V1)/length(dat$V1)# pop. prevalence estimated from data
#R2ROC also allows users to estimate AUC using pre-adjusted phenotype
#In that case, users need to specify kv
#eg. kv=0.10 for dat2 (dat2 embedded within the package) 
v1=c(1)
output=auc_var(dat,v1,nv,kv)

#R2ROC output
#output$auc (AUC)
#0.7390354

#output$var (variance of AUC)
#7.193337e-05

#output$upper_auc (upper limit of 95\% CI for AUC)
#0.7556589

#output$lower_auc (lower limit of 95\% CI for AUC)
#0.7224119
}
\keyword{R2}
\keyword{information}
\keyword{matrix}
\keyword{variance}
