% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlwinfitMCMC.R
\docType{class}
\name{mlwinfitMCMC-class}
\alias{mlwinfitMCMC-class}
\title{An S4 class that stores the outputs of the fitted MCMC model.}
\description{
An MLwiN model run via the MCMC estimation method is represented by an "mlwinfitMCMC" object
}
\section{Slots}{

\describe{
\item{\code{Nobs}}{Computes the number of complete observations.}

\item{\code{DataLength}}{Total number of cases.}

\item{\code{Hierarchy}}{For each higher level of a multilevel model, returns the number of units at that level, together with the minimum, mean and maximum number of lower-level units nested within units of the current level.}

\item{\code{burnin}}{An integer specifying length of the burn-in.}

\item{\code{nchains}}{An integer specifying number of MCMC chains run.}

\item{\code{iterations}}{An integer specifying the number of iterations after burn-in.}

\item{\code{D}}{A vector specifying the type of distribution to be modelled, which can include \code{'Normal'}, \code{'Binomial'} \code{'Poisson'}, \code{'Multinomial'}, \code{'Multivariate Normal'}, or \code{'Mixed'}.}

\item{\code{Formula}}{A formula object (or a character string) specifying a multilevel model.}

\item{\code{levID}}{A character string (vector) of the specified level ID(s).}

\item{\code{contrasts}}{A list of contrast matrices, one for each factor in the model.}

\item{\code{xlevels}}{A list of levels for the factors in the model.}

\item{\code{merr}}{A vector which sets-up measurement errors on predictor variables.}

\item{\code{fact}}{A list of objects specified for factor analysis, including \code{nfact}, \code{lev.fact}, \code{nfactor}, \code{factor}, \code{loading} and \code{constr}.}

\item{\code{xc}}{A list of objects specified for cross-classified and/or multiple membership models, including \code{class}, \code{N1}, \code{weight}, \code{id} and \code{car}.}

\item{\code{FP}}{Displays the fixed part estimates.}

\item{\code{RP}}{Displays the random part estimates.}

\item{\code{FP.cov}}{Displays a covariance matrix of the fixed part estimates.}

\item{\code{RP.cov}}{Displays a covariance matrix of the random part estimates.}

\item{\code{chains}}{Captures the MCMC chains from MLwiN for all parameters.}

\item{\code{elapsed.time}}{Calculates the CPU time used for fitting the model.}

\item{\code{BDIC}}{Bayesian Deviance Information Criterion (DIC)}

\item{\code{call}}{The matched call.}

\item{\code{LIKE}}{The deviance statistic (-2*log(like)).}

\item{\code{fact.loadings}}{If \code{fact} is not empty, then the factor loadings are returned.}

\item{\code{fact.loadings.sd}}{If \code{fact} is not empty, then the factor loading standard deviationss are returned.}

\item{\code{fact.cov}}{If \code{fact} is not empty, then factor covariances are returned.}

\item{\code{fact.cov.sd}}{If \code{fact} is not empty, then factor covariance standard deviations are returned.}

\item{\code{fact.chains}}{If \code{fact} is not empty, then the factor chains are returned.}

\item{\code{MIdata}}{If \code{dami[1]} is one then the mean complete response variable \code{y} is returned for each chain, if \code{dami[1]} is two then the SD is also included.}

\item{\code{imputations}}{If \code{dami[1]} is zero, then a list of completed datasets containing complete response variable \code{y} is returned.}

\item{\code{residual}}{If \code{resi.store} is \code{TRUE}, then the residual estimates at all levels are returned.}

\item{\code{resi.chains}}{If \code{resi.store.levs} is not empty, then the residual chains at these levels are returned.}

\item{\code{version}}{The MLwiN version used to fit the model}

\item{\code{data}}{The data.frame that was used to fit the model.}
}}
\section{An instance of the Class}{

 An instance is created by calling function \code{\link{runMLwiN}}.
}
\examples{
\dontrun{

library(R2MLwiN)
# NOTE: if MLwiN not saved in location R2MLwiN defaults to, specify path via:
# options(MLwiN_path = 'path/to/MLwiN vX.XX/')
# If using R2MLwiN via WINE, the path may look like this:
# options(MLwiN_path = '/home/USERNAME/.wine/drive_c/Program Files (x86)/MLwiN vX.XX/')
  
## Example: tutorial
data(tutorial, package = "R2MLwiN")

(mymodel <- runMLwiN(normexam ~ 1 + standlrt + (1 + standlrt | school) + (1 | student),
                     estoptions = list(EstM = 1), data = tutorial)) 

##summary method
summary(mymodel)

##BDIC slot
mymodel@BDIC
}

}
\author{
Zhang, Z., Charlton, C.M.J., Parker, R.M.A., Leckie, G., and Browne,
W.J. (2016) Centre for Multilevel Modelling, University of Bristol.
}
\seealso{
\code{\link{runMLwiN}}
}

