\name{bayesx.construct}

\alias{bayesx.construct}
\alias{bayesx.construct.bl.smooth.construct}
\alias{bayesx.construct.gk.smooth.construct}
\alias{bayesx.construct.gs.smooth.construct}
\alias{bayesx.construct.mrf.smooth.construct}
\alias{bayesx.construct.ps.smooth.construct}
\alias{bayesx.construct.ra.smooth.construct}
\alias{bayesx.construct.re.smooth.construct}
\alias{bayesx.construct.rw1.smooth.construct}
\alias{bayesx.construct.rw2.smooth.construct}
\alias{bayesx.construct.tensor.smooth.construct}
\alias{bayesx.construct.te.smooth.construct}
\alias{bayesx.construct.lasso.smooth.construct}
\alias{bayesx.construct.ridge.smooth.construct}
\alias{bayesx.construct.nigmix.smooth.construct}
\alias{bayesx.construct.kr.smooth.construct}
\alias{bayesx.construct.season.smooth.construct}
\alias{bayesx.construct.factor.smooth.construct}

\title{
  Construct BayesX Model Term Objects
}

\description{
  The function \code{bayesx.construct} is used to provide a flexible framework to implement 
  new model term objects in \code{\link{bayesx}} within the \pkg{BayesX} syntax. 
}

\usage{
bayesx.construct(object, dir, prg, data)
}

\arguments{
  \item{object}{is a smooth, shrinkage or random specification object in a STAR \code{formula},
    generated by the \code{\link{R2BayesX}} model term constructor functions \code{\link{sx}}
    (or using the constructor functions \code{\link[mgcv]{s}} and
    \code{\link[mgcv]{te}} of the \code{\link[mgcv]{mgcv}} package). Objects generated by
    these functions have class \code{"xx.smooth.spec"} where \code{"xx"} is determined by the
    \code{"bs"} argument of \code{\link{sx}} (and \code{\link[mgcv]{s}}).}
  \item{dir}{\code{character}, a directory where possible data should be stored, e.g. in
    \code{\link{bayesx}} models, if \code{bs = "gk"}, \code{bs = "gs"} or \code{bs = "mrf"} is
    choosen, the corresponding map will be  written as a \code{"bnd"} or \code{"gra"} file (see
    \code{\link{read.bnd}} and \code{\link{read.gra}}) to this directory, so \pkg{BayesX} can use
    this spatial object for estimation.} 
  \item{prg}{if additional data handling must be applied, e.g. storing maps (\code{"bnd"}) objects
    in the directory specified in \code{dir}, \code{\link{write.bayesx.input}} needs to write the
    extra commands in a program file provided with argument \code{prg}, i.e. this may all be handled 
    within a \code{bayesx.construct} constructor function.}
  \item{data}{if additional data is needed to setup the \pkg{BayesX} term it is found here.}
}

\details{
  The main idea of these constructor functions is to provide a flexible framework to implement new 
  model term objects in the \pkg{BayesX} syntax within \code{\link{bayesx}}, i.e. for any smooth or 
  random term in \pkg{R2BayesX} a constructor function like 
  \code{bayesx.construct.ps.smooth.construct} may be provided to translate \R specific syntax into 
  \pkg{BayesX} readable commands. During processing with \code{\link{write.bayesx.input}} each model
  term is constructed with \code{bayesx.construct} after another, wrapped into a full formula, which 
  may then be send to the \pkg{BayesX} binary with function \code{\link[BayesXsrc]{run.bayesx}}.

  At the moment the following model terms are implemented:
  \itemize{
    \item \code{"rw1"}, \code{"rw2"}: Zero degree P-splines: Defines a zero degree P-spline with first or
                            second order difference penalty. A zero degree P-spline typically
                            estimates for every distinct covariate value in the dataset a separate
                            parameter. Usually there is no reason to prefer zero degree P-splines
                            over higher order P-splines. An exception are ordinal covariates or
                            continuous covariates with only a small number of different values.
                            For ordinal covariates higher order P-splines are not meaningful while
                            zero degree P-splines might be an alternative to modeling nonlinear
                            relationships via a dummy approach with completely unrestricted
                            regression parameters.
    \item \code{"season"}: Seasonal effect of a time scale. 
    \item \code{"ps"}, \code{"psplinerw1"}, \code{"psplinerw2"}: P-spline with first or second order 
                                                        difference penalty. 
    \item \code{"te"}, \code{"pspline2dimrw1"}: Defines a two-dimensional P-spline based on the tensor
              product of one-dimensional P-splines with a two-dimensional first order random walk
              penalty for the parameters of the spline. 
    \item \code{"kr"}, \code{"kriging"}: Kriging with stationary Gaussian random fields.  
    \item \code{"gk"}, \code{"geokriging"}: Geokriging with stationary Gaussian random fields: Estimation
              is based on the centroids of a map object provided in
              boundary format (see function \code{\link{read.bnd}} and \code{\link{shp2bnd}}) as an additional
              argument named \code{map} within function \code{\link{sx}}, or supplied within argument
              \code{xt} when using function \code{\link[mgcv]{s}}, e.g., \code{xt = list(map = MapBnd)}. 
    \item \code{"gs"}, \code{"geospline"}: Geosplines based on two-dimensional P-splines with a
              two-dimensional first order random walk penalty for the parameters of the spline.	
	            Estimation is based on the coordinates of the centroids of the regions
              of a map object provided in boundary format (see function \code{\link{read.bnd}} and
              \code{\link{shp2bnd}}) as an additional argument named \code{map} (see above). 
    \item \code{"mrf"}, \code{"spatial"}: Markov random fields: Defines a Markov random field prior for a
               spatial covariate, where geographical information is provided by a map object in
               boundary or graph file format (see function \code{\link{read.bnd}}, \code{\link{read.gra}} and
               \code{\link{shp2bnd}}), as an additional argument named \code{map} (see above).
    \item \code{"bl"}, \code{"baseline"}: Nonlinear baseline effect in hazard regression or multi-state
              models: Defines a P-spline with second order random walk penalty for the parameters of
              the spline for the log-baseline effect \eqn{log(\lambda(time))}. 
    \item \code{"factor"}: Special \pkg{BayesX} specifier for factors, especially meaningful if
                  \code{method = "STEP"}, since the factor term is then treated as a full term,
                  which is either included or removed from the model. 
    \item \code{"ridge"}, \code{"lasso"}, \code{"nigmix"}: Shrinkage of fixed effects: defines a
                                                shrinkage-prior for the corresponding parameters
                                                \eqn{\gamma_j}, \eqn{j = 1, \ldots, q}, \eqn{q \geq 1} of the
                                                linear effects \eqn{x_1, \ldots, x_q}. There are three
                                                priors possible: ridge-, lasso- and Normal Mixture
                                                of inverse Gamma prior.
    \item \code{"re"}: Gaussian i.i.d.\ Random effects of a unit or cluster identification covariate.
  }
  See function \code{\link{sx}} for a description of the main
  \code{\link{R2BayesX}} model term constructor functions.
}

\value{
  The model term syntax used within \pkg{BayesX} as a character string.
}

\note{
  Using \code{\link{sx}} additional controlling arguments may be supplied within the dot dot dot 
  ``\code{...}'' argument. Please see the help site for function \code{\link{bayesx.term.options}}
  for a detailed description of possible optional parameters.
 
  Within the \code{xt} argument in function \code{\link[mgcv]{s}}, additional
  \pkg{BayesX} specific parameters may be also supplied, see the examples below.
}

\section{WARNINGS}{
  If new \code{bayesx.construct} functions are implemented in future work, there may occur problems 
  with reading the corresponding \pkg{BayesX} output files with \code{\link{read.bayesx.output}},
  e.g., if the new objects do not have the structure as implemented with \code{bs = "ps"} etc.,
  i.e. function \code{\link{read.bayesx.output}} must also be adapted in such cases.
} 

\author{
  Nikolaus Umlauf, Thomas Kneib, Stefan Lang, Achim Zeileis.
}

\seealso{
  \code{\link{sx}}, \code{\link{bayesx.term.options}}, \code{\link[mgcv]{s}},
  \code{\link[mgcv]{formula.gam}}, \code{\link{read.bnd}},
  \code{\link{read.gra}}.
}

\examples{
bayesx.construct(sx(x1, bs = "ps"))
bayesx.construct(sx(x1, x2, bs = "te"))

## now create BayesX syntax for smooth terms
## using mgcv constructor functions
bayesx.construct(s(x1, bs = "ps"))

## for tensor product P-splines,
bayesx.construct(s(x1, x2, bs = "te"))

## increase number of knots
## for a P-spline
bayesx.construct(sx(x1, bs = "ps", nrknots = 40))

## now with degree 2 and
## penalty order 1
bayesx.construct(sx(x1, bs = "ps", knots = 40, degree = 2, order = 1))
bayesx.construct(s(x1, bs = "ps", k = 41, m = c(0, 1)))

## random walks
bayesx.construct(sx(x1, bs = "rw1"))
bayesx.construct(sx(x1, bs = "rw2"))

## shrinkage priors
bayesx.construct(sx(x1, bs = "lasso"))
bayesx.construct(sx(x1, bs = "ridge"))
bayesx.construct(sx(x1, bs = "nigmix"))

## for cox models, baseline
bayesx.construct(sx(time, bs = "bl"))

## kriging
bayesx.construct(sx(x, z, bs = "kr"))

## seasonal
bayesx.construct(sx(x, bs = "season"))

## factors
bayesx.construct(sx(id, bs = "factor"))

## now with some geographical information
## note: maps must be either supplied in
## 'bnd' or 'gra' format, also see function
## read.bnd() or read.gra()
data("MunichBnd")
bayesx.construct(sx(id, bs = "mrf", map = MunichBnd))

## same with
bayesx.construct(s(id, bs = "mrf", xt = list(map = MunichBnd)))

bayesx.construct(sx(id, bs = "gk", map = MunichBnd))
bayesx.construct(sx(id, bs = "gs", map = MunichBnd))

## also vary number of knots
bayesx.construct(sx(id, bs = "gs", knots = 10, map = MunichBnd))
bayesx.construct(s(id, bs = "gs", k = 12, m = c(1, 1), xt = list(map = MunichBnd)))

## random effects
bayesx.construct(sx(id, bs = "re"))
bayesx.construct(sx(id, bs = "re", by = x1))
bayesx.construct(sx(id, bs = "re", by = x1, xt = list(nofixed=TRUE)))

## generic
## specifies some model term
## and sets all additional arguments 
## within argument xt
## only for experimental use
bayesx.construct(sx(x, bs = "generic", dosomething = TRUE, a = 1, b = 2))
}

\keyword{regression}
