% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3.R
\name{extract}
\alias{extract}
\alias{extract.CDM}
\alias{extract.validation}
\alias{extract.sim.data}
\title{Extract elements from objects of various classes}
\usage{
extract(object, what, ...)

\method{extract}{CDM}(object, what, ...)

\method{extract}{validation}(object, what, ...)

\method{extract}{sim.data}(object, what, ...)
}
\arguments{
\item{object}{objects from class \code{CDM}, \code{validation}, \code{sim.data}}

\item{what}{what to extract}

\item{...}{Additional arguments.}
}
\description{
A generic function to extract elements from objects of class \code{CDM}, \code{validation} or \code{sim.data}.

Objects which can be extracted from \code{\link[Qval]{CDM}} object include:

\describe{
 \item{analysis.obj}{An \code{GDINA} object (@seealso \code{\link[GDINA]{GDINA}}) gained from \code{GDINA} package or an 
                     \code{list} after BM algorithm, depending on which estimation is used.}
 \item{alpha}{Individuals' attribute parameters calculated by EAP method}
 \item{P.alpha.Xi}{Individual's posterior probability}
 \item{alpha.P}{Individuals' marginal mastery probabilities matrix}
 \item{P.alpha}{Attribute prior weights for calculating marginalized likelihood in the last iteration}
 \item{Deviance}{deviance, or negative two times observed marginal log likelihood}
 \item{npar}{The number of parameters}
 \item{AIC}{AIC}
 \item{BIC}{BIC}
}

Objects which can be extracted from \code{\link[Qval]{validation}} object include:

\describe{
 \item{Q.orig}{The original Q-matrix that maybe contain some mis-specifications and need to be validated.}
 \item{Q.sug}{The Q-matrix that suggested by certain validation method.}
 \item{time.cost}{The time that CPU cost to finish the validation.}
 \item{process}{A matrix that contains the modification process of each item during each iteration. 
       Each row represents an iteration, and each column corresponds to the q-vector index of respective 
       item. The order of the indices is consistent with the row number in the matrix generated by 
       the \code{\link[GDINA]{attributepattern}} function in the \code{GDINA} package. Only when 
       \code{maxitr} > 1, the value is available.}
 \item{iter}{The number of iteration. Only when \code{maxitr} > 1, the value is available.}
 \item{priority}{An \code{I} × \code{K} matrix that contains the priority of every attribute for
                each item. Only when the \code{search.method} is \code{"PAA"}, the value is available.}
 \item{Hull.fit}{A \code{list} containing all the information needed to plot the Hull plot, which is 
                available only when \code{method} = \code{"Hull"}.}
}

Objects which can be extracted from \code{\link[Qval]{sim.data}} object include:

\describe{
 \item{dat}{An \code{N} × \code{I} simulated item response matrix.}
 \item{Q}{The Q-matrix.}
 \item{attribute}{An \code{N} × \code{K} matrix for inviduals' attribute patterns.}
 \item{catprob.parm}{A list of non-zero category success probabilities for each attribute mastery pattern.}
 \item{delta.parm}{A list of delta parameters.}
 \item{higher.order.parm}{Higher-order parameters.}
 \item{mvnorm.parm}{Multivariate normal distribution parameters.}
 \item{LCprob.parm}{A matrix of item/category success probabilities for each attribute mastery pattern.}
}
}
\section{Methods (by class)}{
\itemize{
\item \code{extract(CDM)}: various elements of \code{CDM} object

\item \code{extract(validation)}: various elements of \code{validation} object

\item \code{extract(sim.data)}: various elements of \code{sim.data} object

}}
\examples{
set.seed(123)

library(Qval)

## generate Q-matrix and data to fit
K <- 3
I <- 30
example.Q <- sim.Q(K, I)
IQ <- list(
  P0 = runif(I, 0.0, 0.2),
  P1 = runif(I, 0.8, 1.0)
)
example.data <- sim.data(Q = example.Q, N = 1000, IQ = IQ,
                         model = "GDINA", distribute = "horder")
extract(example.data,"dat")


## using MMLE/EM to fit GDINA model
example.CDM.obj <- CDM(example.data$dat, example.Q, model = "GDINA",
                       method = "EM", maxitr = 2000, verbose = 1)
extract(example.CDM.obj,"alpha")
extract(example.CDM.obj,"npar")

example.MQ <- sim.MQ(example.Q, 0.1)
example.CDM.obj <- CDM(example.data$dat, example.MQ, model = "GDINA",
                       method = "EM", maxitr = 2000, verbose = 1)
                       
validation.obj <- validation(example.data$dat, example.MQ, 
                             example.CDM.obj, method = "MLR-B", eps = 0.90)
extract(validation.obj,"Q.sug")

}
