% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Qvalindex.R
\name{zQRR}
\alias{zQRR}
\title{Caculate Q-matrix recovery rate (QRR)}
\usage{
zQRR(Q.true, Q.sug)
}
\arguments{
\item{Q.true}{The true Q-matrix.}

\item{Q.sug}{A The Q-matrix that has being validated.}
}
\value{
A numeric (QRR index).
}
\description{
Caculate Q-matrix recovery rate (QRR)
}
\details{
The Q-matrix recovery rate (QRR) provides information on overall performance, and is defned as:
\deqn{
 QRR = \frac{\sum_{i=1}^{I}\sum_{k=1}^{K}I(q_{ik}^{t} = q_{ik}^{s})}{I × K}
}
where \eqn{q_{ik}^{t}} denotes the \eqn{k}th attribute of item \eqn{i} in the true Q-matrix (\eqn{Q.true}),
\eqn{q_{ik}^{s}} denotes \eqn{k}th attribute of item \eqn{i} in the suggested Q-matrix(\eqn{Q.sug}),
and \eqn{I(\cdot)} is the indicator function.
}
\examples{
library(Qval)

set.seed(123)

example.Q1 <- sim.Q(5, 30)
example.Q2 <- sim.MQ(example.Q1, 0.1)
QRR <- zQRR(example.Q1, example.Q2)
print(QRR)

}
