% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TernaryPoints.R
\name{QuartetPoints}
\alias{QuartetPoints}
\alias{SplitPoints}
\alias{BipartitionPoints}
\title{Plot tree differences on ternary plots}
\usage{
QuartetPoints(trees, cf = trees[[1]])

SplitPoints(trees, cf = trees[[1]])

BipartitionPoints(trees, cf = trees[[1]])
}
\arguments{
\item{trees}{A list of trees of class \code{\link[ape:read.tree]{phylo}},
with identically labelled tips.}

\item{cf}{Comparison tree of class \code{\link[ape:read.tree]{phylo}}.  If unspecified,
each tree is compared to the first tree in \code{trees}.}
}
\value{
A data frame listing the ternary coordinates of trees, based on the
amount of information that they have in common with the comparison
tree (which defaults to the first member of the list, if unspecified).
}
\description{
Generate points to depict tree difference (in terms of resolution
and accuracy) on a ternary plot.
}
\details{
The ternary plot will depict the number of quartets or splits that are:
\itemize{
\item resolved in the reference tree (\code{cf}), but neither present nor contradicted
in each comparison tree (\code{trees});
\item resolved differently in the reference and the comparison tree;
\item resolved in the same manner in the reference and comparison trees.
}

If the reference tree (\code{cf}) is taken to represent the best possible knowledge
of the 'true' topology, then polytomies in the reference tree represent
uncertainty.  If a tree in \code{trees} resolves relationships within this
polytomy, it is not possible to establish (based only on the reference tree)
whether this resolution is correct or erroneous.  As such, extra resolution
in \code{trees} that is neither corroborated nor contradicted by \code{cf} is ignored.
}
\section{Functions}{
\itemize{
\item \code{SplitPoints}: Uses partitions instead of quartets to calculate
tree distances.
}}

\examples{
{
  library('Ternary')
  data('sq_trees')
  
  TernaryPlot(alab='Unresolved', blab='Contradicted', clab='Consistent', point='right')
  TernaryLines(list(c(0, 2/3, 1/3), c(1, 0, 0)), col='red', lty='dotted')
  TernaryText(QuartetPoints(sq_trees, cf=sq_trees$collapse_one), 1:15, 
    col=Ternary::cbPalette8[2], cex=0.8)
  TernaryText(SplitPoints(sq_trees, cf=sq_trees$collapse_one), 1:15, 
    col=Ternary::cbPalette8[3], cex=0.8)
  legend('bottomright', c("Quartets", "Splits"), bty='n', pch=1, cex=0.8,
    col=Ternary::cbPalette8[2:3])
  
}

}
\references{
\insertRef{Smith2019}{Quartet}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
