#!/bin/R

NMI_pyclone<-function(path){
	input<-read.table(path, header = TRUE,sep = "\t")
	clones<-sapply(input$mutation_id, function(z){
		strsplit(strsplit(as.character(z),split = 'r')[[1]][2],split = ':')[[1]][1]
		}
		)
	cluster<-input$cluster_id
	P_cluster<-table(cluster)/length(cluster)
	P_clone<-table(clones)/length(clones)

	Hclones<- - sum(P_clone*log(P_clone))
	Hcluster<- - sum(P_cluster*log(P_cluster))
	A<-aggregate(rep(1,length(cluster)),
		by= list(x = cluster,
			y= clones),
		sum
		)
	L<-log(A[,3]/(length(cluster)*P_cluster[A[,1]]*P_clone[A[,2]]))
	return(2*sum(A[,3]/length(cluster)*L)/(Hclones+Hcluster) )	
}

Remove_time_errors<-function(time){
	med<-median(time)
	result<-time
	result[result < med/10 | result > med * 10]<-NA
	return(result)
}
cnum<-function(x) as.numeric(as.character(x))
