% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_fmx.R
\name{autolayer_fmx_discrete}
\alias{autolayer_fmx_discrete}
\title{Create \link[ggplot2]{layer} for Discrete \linkS4class{fmx} Objects}
\usage{
autolayer_fmx_discrete(
  object,
  type = c("density", "distribution"),
  data = object@data,
  xlim = if (length(data)) data else qfmx(p = c(0.01, 0.99), dist = object),
  bins = 60L,
  ...
)
}
\arguments{
\item{object}{\linkS4class{fmx} object}

\item{type}{\link[base]{character} scalar.
Option \code{'density'} (default) plots the probability density for \linkS4class{fmx} input
(and the histogram if argument \code{data} is available).
Option \code{'distribution'} plots the cumulative probability distribution for \linkS4class{fmx} input
(and the cumulative histogram if argument \code{data} is available).}

\item{data}{(optional) \link[base]{numeric} (actually \link[base]{integer}) \link[base]{vector} of the observations.
Default is the slot \code{object@data}.}

\item{xlim}{\link[base]{numeric} length-two \link[base]{vector}, horizontal range}

\item{bins}{\link[base]{integer} scalar}

\item{...}{additional parameters, currently not in use}
}
\value{
\link{autolayer_fmx_discrete} returns a \link[base]{list} of \link[ggplot2]{layer}s.
}
\description{
..
}
\seealso{
\link[ggplot2]{autolayer}
}
