% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vuniroot2.R
\name{vuniroot2}
\alias{vuniroot2}
\title{Vectorised One Dimensional Root (Zero) Finding}
\usage{
vuniroot2(
  y,
  f,
  interval = stop("must provide a length-2 `interval`"),
  tol = .Machine$double.eps^0.25,
  maxiter = 1000L
)
}
\arguments{
\item{y}{\link[base]{numeric} \link[base]{vector} of \eqn{y} values}

\item{f}{monotone \link[base]{function} \eqn{f(x)} whose roots are to be solved}

\item{interval}{length two \link[base]{numeric} \link[base]{vector}}

\item{tol}{\link[base]{double} scalar, desired accuracy (convergence tolerance),}

\item{maxiter}{\link[base]{integer} scalar, maximum number of iterations}
}
\value{
\link{vuniroot2} returns a \link[base]{numeric} \link[base]{vector} \eqn{x} as the solution of \eqn{y = f(x)} with given vector \eqn{y}.
}
\description{
To solve a monotone function \eqn{y = f(x)} for a given \link[base]{vector} of \eqn{y} values.
}
\details{
\link{vuniroot2}, different from \link[rstpm2]{vuniroot}, does
\itemize{
\item{accept \code{NA_real_} as element(s) of \eqn{y}}
\item{handle the case when the analytical root is at \code{lower} and/or \code{upper}}
\item{return a root of \code{Inf} (if \code{abs(f(lower)) >= abs(f(upper))}) or
\code{-Inf} (if \code{abs(f(lower)) < abs(f(upper))}),
when the function value \code{f(lower)} and \code{f(upper)} are not of opposite sign.}
}
}
\examples{
library(rstpm2)
lwr = rep(1, times = 9L); upr = rep(3, times = 9L)

# ?rstpm2::vuniroot does not accept NA \eqn{y}
tryCatch(vuniroot(function(x) x^2 - c(NA, 1:8), lower = lwr, upper = upr), error = identity)

# ?rstpm2::vuniroot not good when the analytic root is at `lower` or `upper`
f <- function(x) x^2 - 1:9
tryCatch(vuniroot(f, lower = lwr, upper = upr, extendInt = 'no'), warning = identity)
tryCatch(vuniroot(f, lower = lwr, upper = upr, extendInt = 'yes'), warning = identity)
tryCatch(vuniroot(f, lower = lwr, upper = upr, extendInt = 'downX'), error = identity)
tryCatch(vuniroot(f, lower = lwr, upper = upr, extendInt = 'upX'), warning = identity)

vuniroot2(c(NA, 1:9), f = function(x) x^2, interval = c(1, 3)) # all good

}
\seealso{
\link[rstpm2]{vuniroot}
}
