% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlogis.R
\name{mlogis}
\alias{mlogis}
\alias{qmlogis_first}
\alias{qmlogis_last}
\alias{pmlogis_first}
\alias{pmlogis_last}
\title{Transformation between Multinomial Probabilities & Logits}
\usage{
qmlogis_first(p)

qmlogis_last(p)

pmlogis_first(q)

pmlogis_last(q)
}
\arguments{
\item{p}{\link[base]{numeric} vector of multinomial probabilities, adding up to 1}

\item{q}{\link[base]{numeric} vector of multinomial logits}
}
\value{
\link{pmlogis_first} and \link{pmlogis_last} return a vector of multinomial probabilities \eqn{p}.

\link{qmlogis_first} and \link{qmlogis_last} returns a vector of multinomial logits \eqn{q}.
}
\description{
Performs transformation between vectors of multinomial probabilities and multinomial logits.

This transformation is a generalization of \link[stats]{plogis} which converts scalar logit into probability
and \link[stats]{qlogis} which converts probability into scalar logit.
}
\details{
\link{pmlogis_first} and \link{pmlogis_last} take a length \eqn{k-1} \link[base]{numeric} vector of 
multinomial logits \eqn{q} and convert them into length \eqn{k} multinomial probabilities \eqn{p}, 
regarding the first or last category as reference, respectively.

\link{qmlogis_first} and \link{qmlogis_last} take a length \eqn{k} \link[base]{numeric} vector of 
multinomial probabilities \eqn{p} and convert them into length \eqn{k-1} multinomial logits \eqn{q}, 
regarding the first or last category as reference, respectively.
}
\examples{
(a = qmlogis_last(c(2,5,3)))
(b = qmlogis_first(c(2,5,3)))
pmlogis_last(a)
pmlogis_first(b)

q0 = .8300964
(p1 = pmlogis_last(q0))
(q1 = qmlogis_last(p1))

# various exceptions
pmlogis_first(qmlogis_first(c(1, 0)))
pmlogis_first(qmlogis_first(c(0, 1)))
pmlogis_first(qmlogis_first(c(0, 0, 1)))
pmlogis_first(qmlogis_first(c(0, 1, 0, 0)))
pmlogis_first(qmlogis_first(c(1, 0, 0, 0)))
pmlogis_last(qmlogis_last(c(1, 0)))
pmlogis_last(qmlogis_last(c(0, 1)))
pmlogis_last(qmlogis_last(c(0, 0, 1)))
pmlogis_last(qmlogis_last(c(0, 1, 0, 0)))
pmlogis_last(qmlogis_last(c(1, 0, 0, 0)))

}
\seealso{
\link[stats]{plogis} \link[stats]{qlogis}
}
