% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Step_fmx.R
\name{drop1_fmx}
\alias{drop1_fmx}
\alias{drop1.fmx_QLMDe}
\alias{add1.fmx_QLMDe}
\title{Add or Drop One Possible Parameters of \linkS4class{fmx_QLMDe} Object}
\usage{
\method{drop1}{fmx_QLMDe}(object, scope, test = c("logLik", "AIC", "BIC"), ...)

\method{add1}{fmx_QLMDe}(object, scope, ...)
}
\arguments{
\item{object}{\linkS4class{fmx_QLMDe} object}

\item{scope}{a \link[base]{list} of \link[base]{character} vectors to denote one or more constraints}

\item{test}{\link[base]{character}, either \code{'logLik'} (default), \code{'AIC'} or \code{'BIC'}}

\item{...}{additional parameters, currently not in use.}
}
\value{
\link{drop1.fmx_QLMDe} returns an \link[stats:anova]{ANOVA} table with additional attributes
\itemize{
\item{\code{models}} {a \link[base]{list} of \linkS4class{fmx_QLMDe} objects}
\item{\code{objF}} {a \link[base]{list} of objective functions (depends on \code{test})}
\item{\code{o1}} {the location of the optimal models by \code{test}.  If the original model is optimal, this value is \code{integer()}}
}

\link{add1.fmx_QLMDe} will be added in the next release.
}
\description{
Compute all the single terms in the \code{scope} argument that can be added to or dropped from the model, 
fit those models and compute a table of the changes in fit.
}
\details{
Do \strong{not} write as S3 method of \link[MASS]{dropterm} function, 
as there's no \strong{term} for \linkS4class{fmx_QLMDe} object.
}
\seealso{
\link[stats]{add1} \link[stats]{drop1}
}
