% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Quandldatatable.R
\name{Quandl.datatable}
\alias{Quandl.datatable}
\title{Retrieves Data from the Quandl Datatable endpoint}
\usage{
Quandl.datatable(code, paginate = FALSE, ...)
}
\arguments{
\item{code}{Datatable code on Quandl specified as a string.}

\item{paginate}{When set to TRUE, fetches up to 1,000,000 rows of data}

\item{...}{Additional named values that are interpreted as Quandl API parameters.}
}
\value{
Returns a data.frame.
}
\description{
Retrieves Data from the Quandl Datatable endpoint
}
\details{
Set your \code{api_key} with \code{Quandl.api_key} function. For instructions on finding your api key go to \url{https://www.quandl.com/account/api}
}
\examples{
\dontrun{
Quandl.datatable('ZACKS/FC', paginate=TRUE)
}
}
\seealso{
\code{\link{Quandl.api_key}}
}

