% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRTthre.R
\name{LRTthre}
\alias{LRTthre}
\title{LRT Threshold}
\usage{
LRTthre(
  marker,
  type = "RI",
  ng = 2,
  cM = TRUE,
  ns = 200,
  gv = 25,
  speed = 1,
  simu = 1000,
  d.eff = FALSE,
  alpha = 0.05,
  console = TRUE
)
}
\arguments{
\item{marker}{matrix. A k*2 matrix contains the marker information,
where the row dimension k is the number of markers in the chromosomes.
The first column labels the chromosomes where the markers are located,
and the second column labels the positions of QTLs (in morgan (M) or
centimorgan (cM)). Note that chromosomes and positions must be divided
in order.}

\item{type}{character. The population type of the dataset. Include
backcross (type="BC"), advanced intercross population (type="AI"), and
recombinant inbred population (type="RI").}

\item{ng}{integer. The generation number of the population type. For
example, the BC1 population is type="BC" with ng=1; the AI F3
population is type="AI" with ng=3.}

\item{cM}{logical. Specify the unit of marker position. cM=TRUE for
centimorgan. Or cM=FALSE for morgan.}

\item{ns}{integer. The number of individuals for generating the
individual trait values. The change in this value do not affect
the outcome of the LRT threshold value significantly.}

\item{gv}{numeric. The genetic variance for generating the
individual trait values. The change in this value do not affect
the outcome of the LRT threshold value significantly.}

\item{speed}{numeric. The walking speed of the QTL analysis (in cM).}

\item{simu}{integer. To decide how many simulation samples will be used
to compute the LRT threshold using the Gaussian process.}

\item{d.eff}{logical. Specify whether the dominant effect will be
considered in the parameter estimation or not for AI or RI population.}

\item{alpha}{numeric. The type I error rate for the LRT threshold.}

\item{console}{logical. To decide whether the process of the algorithm
will be shown in the R console or not.}
}
\value{
The LRT threshold for QTL interval mapping.
}
\description{
The LRT threshold for QTL interval mapping based on the
Gaussian stochastic process (Kao and Ho 2012).
}
\examples{
# load the example data
load(system.file("extdata", "exampledata.RDATA", package = "QTLEMM"))

# run and result
LRTthre(marker, type = "RI", ng = 2, speed = 2, simu = 60)
}
\references{
KAO, C.-H. and H.-A. Ho 2012 A score-statistic approach for determining
threshold values in QTL mapping. Frontiers in Bioscience. E4, 2670-2682.
}
\seealso{
\code{\link[mvtnorm]{rmvnorm}}
}
