% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{set_study}
\alias{set_study}
\title{Set the Current Active Study}
\usage{
set_study(study_name)
}
\arguments{
\item{study_name}{The name of the study.}
}
\value{
No return value.
}
\description{
Updates the current active study in the internal state object using the 
studyDbId, which is associated with the given study_name 
parameter.
}
\examples{
if(interactive()) {
  # Configure your server connection
  set_qbms_config("https://bms.icarda.org/ibpworkbench")

  # Login using your account (interactive mode)
  # You can pass your username and password as parameters (batch mode)
  login_bms()

  # Select a crop by name
  set_crop("wheat")

  # Select a breeding program by name
  set_program("Wheat International Nurseries")

  # Select a specific study/trial by name
  set_trial("IDYT39")

  # Select a specific environment/location dataset
  set_study("IDYT39 Environment Number 9")
}

}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{set_program}}, \code{\link{set_trial}}, \code{\link{list_studies}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
