% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_qbms_connection}
\alias{get_qbms_connection}
\title{Get the QBMS Connection}
\usage{
get_qbms_connection()
}
\value{
A list containing the current connection configuration and status.
}
\description{
Retrieves the QBMS connection object from the current environment.
}
\examples{
if(interactive()) {
  # Configure your server connection
  set_qbms_config("https://bms.icarda.org/ibpworkbench")

  # Login using your account (interactive mode)
  # You can pass your username and password as parameters (batch mode)
  login_bms()

  # Select a crop by name
  set_crop("wheat")

  # Select a breeding program by name
  set_program("Wheat International Nurseries")
     
  # Get germplasm data
  df1 <- get_germplasm_data("Jabal")
  
  # Save the current connection (phenotypic server)
  con1 <- get_qbms_connection()
  
  # Configure QBMS to connect to the genotypic server
  set_qbms_config("https://gigwa.southgreen.fr/gigwa/", engine = "gigwa", no_auth = TRUE)
  
  # Set the db, project, and run
  gigwa_set_db("DIVRICE_NB")
  gigwa_set_project("refNB")
  gigwa_set_run("03052022")
  
  # Get associated metadata
  df2 <- gigwa_get_metadata()
  
  # Save the current connection (before switch)
  con2 <- get_qbms_connection()
  
  # Load the saved phenotypic server connection
  set_qbms_connection(con1)
  
  # Continue retrieving germplasm attributes from the phenotypic server
  df3 <- get_germplasm_attributes("Jabal")
}

}
\seealso{
\code{\link{set_qbms_connection}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
