% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{set_program}
\alias{set_program}
\title{Set the current active breeding program}
\usage{
set_program(program_name)
}
\arguments{
\item{program_name}{the name of the breeding program}
}
\value{
no return value
}
\description{
This function will update the current active breeding program in the
internal state object using the programDbId retrieved from BMS which is
associated to the given program_name parameter.
}
\examples{
if(interactive()) {
# config your BMS connection
set_qbms_config("https://www.bms-uat-test.net/ibpworkbench")

# login using your BMS account (interactive mode)
# you can pass BMS username and password as parameters (batch mode)
login_bms()

set_crop("maize")

# select a breeding program by name
set_program("MC Maize")
}
}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{list_programs}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
