% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AND.R
\name{mleAND}
\alias{mleAND}
\title{Maximum likelihood estimation (MLE) for the quantile-based asymmetric normal distribution.}
\usage{
mleAND(y)
}
\arguments{
\item{y}{This is a vector of quantiles.}
}
\value{
The maximum likelihood estimate of parameter \eqn{\theta=(\mu,\phi,\alpha)} of the quantile-based asymmetric normal distribution.
}
\description{
The log-likelihood function \eqn{\ell_n(\mu,\phi,\alpha)=\ln[L_n(\mu,\phi,\alpha)]}
and parameter estimation of \eqn{ \theta=(\mu,\phi,\alpha)} in the asymmetric normal distribution
by using the maximum likelihood estimation are discussed in Gijbels et al. (2019a).
}
\examples{
\donttest{
# Maximum likelihood estimation
y=rnorm(100)
mleAND(y)
}
}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019a). On quantile-based asymmetric family of distributions: properties and inference. \emph{International Statistical Review}, to appear.
}
}
