% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PythonInR.R
\name{pyConnect}
\alias{pyConnect}
\alias{pyConnectWinDll}
\title{connects R to Python}
\usage{
pyConnect(pythonExePath = NULL, dllDir = NULL, pythonHome = NULL)

pyConnectWinDll(dllName, dllDir, majorVersion, pythonHome, pyArch,
  useCstdout = NULL)
}
\arguments{
\item{pythonExePath}{a character containing the path to "python.exe" 
(e.g. "C:\\Python27\\python.exe")}

\item{dllDir}{an optional character giving the path to the dll file. 
Since the dll file is normally in a system folder or in the same 
location as python.exe, this parameter is \bold{almost never needed}!}

\item{pythonHome}{an optional character giving the path to PYTHONHOME.
On Windows by default PYTHONHOME is the folder where python.exe 
is located, therefore this parameter is \bold{normally not needed}.}

\item{dllName}{a character giving the name of the dll file 
(e.g.d \code{"python27.dll"}).}

\item{majorVersion}{an integer giving the major Python version
(e.g. \code{2} or \code{3}).}

\item{pyArch}{a character giving the Python architecture, 
i.e. \code{"32bit"} or \code{"64bit"}.}

\item{useCstdout}{a logical indicating if the \code{C} stdout should be
used or the stout should be redirected at a Python level.}
}
\description{
Connects R to Python. 
             \strong{(The parameters are only needed for the Windows version!)}
}
\details{
There is a different behavior for the static (Linux default)
         and the explicit linked (Windows default) version. Where as the
         static linked version automatically connects, when the package get's loaded,
         the explicitly linked version needs to be connected manually. 
         More information can be found at the README file or at 
         \url{http://pythoninr.bitbucket.org/}.
}
\note{
See the \strong{README} for more information about the Windows setup.
}
\examples{
\dontrun{
## Linux examples
pyConnect() # is done by default when the package is loaded

## Windows examples
pyConnect() ## will try to detect a suitable python version 
            ## from the PATH given in the environment variables
pyConnect("C:\\\\Python27\\\\python.exe")

## One can also explicitly set the parameters for the connection.
PythonInR:::pyConnectWinDll(dllName="python27.dll", dllDir=NULL,
                            majorVersion=2, pythonHome="C:\\\\Python27", 
                            pyArch="32bit")
}
}
