% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_and_downsample.R
\name{clean_missing_data}
\alias{clean_missing_data}
\title{Clean missing data above an acceptable threshold}
\usage{
clean_missing_data(data, pupil, trial_threshold = 1,
  subject_trial_threshold = 1)
}
\arguments{
\item{data}{your data of class PupillometryR}

\item{pupil}{a column name denoting pupil size}

\item{trial_threshold}{a proportion of missing data over which a trial can be considered lost}

\item{subject_trial_threshold}{a proportion of missing trials over which a participant can be considered lost.}
}
\value{
A cleaned PupillometryR dataframe
}
\description{
This function can be used to remove trials and participants
who do not meet the threshold for a study. Note that there are two parameters for
cleaning, one to remove trials above a threshold,
the second to remove participants who drop more than a certain amount of trials.
}
\examples{
data(pupil_data)
Sdata <- make_pupillometryr_data(data = pupil_data,
subject = ID,
trial = Trial,
time = Time,
condition = Type)
new_data <- downsample_time_data(data = Sdata,
pupil = LPupil,
timebin_size = 50,
option = 'mean')
calculate_missing_data(data = new_data, pupil = LPupil)
}
