% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish.Score.R
\name{publish.Score}
\alias{publish.Score}
\title{Publish predictive accuracy results}
\usage{
\method{publish}{Score}(object, metrics, score = TRUE, contrasts = TRUE, level = 3, ...)
}
\arguments{
\item{object}{Object obtained with \code{riskRegression::Score}}

\item{metrics}{Which metrics to put into tables. Defaults to
\code{object$metrics}.}

\item{score}{Logical. If \code{TRUE} print the score elements, i.e., metric applied to the risk prediction models.}

\item{contrasts}{Logical. If \code{TRUE} print the contrast elements (if any). These compare risk prediction models according to metrics.}

\item{level}{Level of subsection headers, i.e., ** for level 2 and
*** for level 3 (useful for emacs org-users). Default is plain
subsection headers no stars.  A negative value will suppress
subjection headers.}

\item{...}{Passed to publish}
}
\value{
Results of Score in tabular form
}
\description{
Write output of \code{riskRegression::Score} in tables
}
\details{
Collect prediction accuracy results in tables
}
\examples{
library(riskRegression)
library(survival)
learn = sampleData(100)
val= sampleData(100)
f1=CSC(Hist(time,event)~X1+X8,data=learn)
f2=CSC(Hist(time,event)~X1+X5+X6+X8,learn)
xs=Score(list(f1,f2),data=val,formula=Hist(time,event)~1)
publish(xs)

}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
