% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{svalue}
\alias{svalue}
\title{Estimate publication bias needed to "explain away" results}
\usage{
svalue(yi, vi, q, clustervar = 1:length(yi), model, eta.grid = seq(1,
  200, 0.25), CI.level = 0.95, small = TRUE)
}
\arguments{
\item{yi}{A vector of point estimates to be meta-analyzed}

\item{vi}{A vector of estimated variances for the point estimates}

\item{q}{The attenuated value to which to shift the point estimate or CI. Should be specified on the same scale as \code{yi}
(e.g., if \code{yi} is on the log-RR scale, then \code{q} should be as well).}

\item{clustervar}{A character, factor, or numeric vector with the same length as \code{yi}. Unique values should indicate
unique clusters of point estimates. By default, assumes all point estimates are independent.}

\item{model}{\code{"fixed"} for fixed-effects or \code{"robust"} for robust random-effects}

\item{eta.grid}{A vector of values of eta to try for the grid search. The vector should start at 1 and end at a large number, such
as 200. For a more precise estimate of eta, use more closely-spaced values. This argument is only needed when \code{model = "robust"}.}

\item{CI.level}{Confidence interval level (as proportion) for the corrected point estimate}

\item{small}{Should inference allow for a small meta-analysis? We recommend using \code{TRUE} even for large meta-analyses.}
}
\description{
Estimates the S-value, defined as the severity of publication bias (i.e., the ratio
by which affirmative studies are more likely to be published than nonaffirmative studies)
that would be required to shift the pooled point estimate or its confidence interval limit
to the value \code{q}.
}
\details{
For example, if the S-value for the point estimate is 30 with \code{q=0}, this indicates that affirmative studies
(i.e., those with a "statistically significant" and positive estimate) would need to be 30-fold more likely to be published
than nonaffirmative studies (i.e., those with a "nonsignificant" or negative estimate) to attenuate the pooled point estimate to
\code{q}.
}
\examples{
# calculate effect sizes from example dataset in metafor
require(metafor)
dat = metafor::escalc(measure="RR", ai=tpos, bi=tneg, ci=cpos, di=cneg, data=dat.bcg)

##### Fixed-Effects Specification #####
# S-values and worst-case meta-analysis under fixed-effects specification
svals.FE.0 = svalue( yi = dat$yi,
                   vi = dat$vi,
                   q = 0,
                   model = "fixed" )

# publication bias required to shift point estimate to 0
svals.FE.0$svals$sval.est

# and to shift CI to include 0
svals.FE.0$svals$sval.ci

# now try shifting to a nonzero value (RR = 0.90)
svals.FE.q = svalue( yi = dat$yi,
                     vi = dat$vi,
                     q = log(.9),
                     model = "fixed" )

# publication bias required to shift point estimate to RR = 0.90
svals.FE.q$svals$sval.est

# and to shift CI to RR = 0.90
svals.FE.q$svals$sval.ci

##### Robust Clustered Specification #####
# takes ~1 min to run due to grid search
\dontrun{
  svalue( yi = dat$yi,
          vi = dat$vi,
          q = 0,
          model = "robust" )
}
}
\references{
1. Mathur MB & VanderWeele TJ (2019). Sensitivity analysis for publication bias in meta-analyses. Preprint available at XXX.
}
