% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getter_functions.R
\name{sectionList}
\alias{sectionList}
\alias{sectionList.PugViewInstance}
\alias{sectionList.PugViewSectionList}
\alias{sectionList.PugViewSection}
\title{List Available Section/Subsections}
\usage{
sectionList(object, ...)

\method{sectionList}{PugViewInstance}(object, ...)

\method{sectionList}{PugViewSectionList}(
  object,
  .pattern = NULL,
  .match_type = c("contain", "match", "start", "end"),
  ...
)

\method{sectionList}{PugViewSection}(
  object,
  .pattern = NULL,
  .match_type = c("contain", "match", "start", "end"),
  ...
)
}
\arguments{
\item{object}{an object of PubChem request, generally returned from \link{get_pug_view}.}

\item{...}{other arguments. Currently has no effect on the outputs. Can be ignored.}

\item{.pattern}{a character vector. Each text pattern given here will be searched within Pug View sections by using the pattern matching strategy defined with \code{.match_type}. If not specified or NULL, all available sections will be returned.}

\item{.match_type}{a string. How should search patterns (i.e., \code{.pattern}) matched with section names? Available options are "contain", "match", "start", and "end" which can be used for partial and/or exact pattern matching. Default is "contain". See Details below for more information.}
}
\description{
This function may be used to list available sections (or subsections) of a PubChem request returned from \link{get_pug_view}. It is useful when one wants to extract a specific section (or subsection) from PubChem request. It supports patteern-specific searches within sections. See Detail/Note below for more information.
}
\details{
Pattern matching is used to filter sections that match user-defined patterns. It is useful when there are more sections than allowed to print R console. In such situations, it may be reasonable to print a subset of all section list to R console that meets search criteria. There are several pattern matching methods as described below
\itemize{
  \item \bold{Partial Matching} ("contain", "start", "end"): Returns the section names that contains or starts/ends by given text patterns.
  \item \bold{Exact Matching} ("match"): Returns the section names that exactly matches given text patterns.
}
}
\examples{
pview <- get_pug_view(identifier = "2244", annotation = "data", domain = "compound")

# List all section names
sectionList(pview)

# Pattern-matched section names
sectionList(pview, .pattern = c("safety", "chemical"), .match_type = "contain")
sectionList(pview, .pattern = "safety", .match_type = "match")
sectionList(pview, .pattern = "properties", .match_type = "end")

# Use section IDs to extract section data from Pug View request
section(pview, "S12") # Safety and Hazards

}
\seealso{
\link{section}
}
