% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_synonyms.R
\name{get_synonyms}
\alias{get_synonyms}
\title{Retrieve Synonyms from PubChem}
\usage{
get_synonyms(
  identifier,
  namespace = "cid",
  domain = "compound",
  searchtype = NULL,
  options = NULL
)
}
\arguments{
\item{identifier}{A character or numeric value specifying the identifier for the request.}

\item{namespace}{A character string specifying the namespace for the request. Default is 'cid'.}

\item{domain}{A character string specifying the domain for the request. Default is 'compound'.}

\item{searchtype}{A character string specifying the search type. Default is NULL.}

\item{options}{Additional arguments passed to PubChem request.}
}
\value{
An object of class 'PubChemInstance_Synonyms', which is a list containing information retrieved from the PubChem database. Synonyms data can be extracted from the returned object using the \link{synonyms} function.
}
\description{
This function sends a request to PubChem to retrieve synonyms for a given identifier.
It returns a list of synonyms corresponding to the provided identifier.
}
\examples{
syns <- get_synonyms(
  identifier = "aspirin",
  namespace = "name"
)

synonyms(syns)

}
