% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PsychWordVec.R
\name{test_RND}
\alias{test_RND}
\title{Relative Norm Distance (RND) analysis.}
\usage{
test_RND(data, T1, A1, A2, use.pattern = FALSE, labels, rev = FALSE)
}
\arguments{
\item{data}{A \code{data.table} (of new class \code{wordvec})
loaded by \code{\link{data_wordvec_load}}.}

\item{T1}{Target words of a single category (a vector of words or a pattern of regular expression).}

\item{A1, A2}{Attribute words (a vector of words or a pattern of regular expression).
Both must be specified.}

\item{use.pattern}{Defaults to \code{FALSE} (using a vector of words).
If you use regular expression in \code{T1}, \code{T2}, \code{A1}, and \code{A2},
please specify this argument as \code{TRUE}.}

\item{labels}{Labels for target and attribute concepts (a named \code{list}),
such as (the default)
\code{list(T1="Target", A1="Attrib1", A2="Attrib2")}.}

\item{rev}{Reverse the results? Defaults to \code{FALSE},
which means that a positive (vs. negative) value of RND indicates
the target words are more associated with A2 than A1.
If reversed (\code{TRUE}), then the interpretation of RND will also be reversed.}
}
\value{
A \code{list} of objects:
\describe{
  \item{\code{words.valid}}{
    valid (actually matched) words}
  \item{\code{data.rnd}}{
    \code{data.table} of (raw and relative) norm distances}
  \item{\code{code.diff}}{
    description for the difference between the two attribute concepts}
  \item{\code{eff.type}}{
    effect type: RND}
  \item{\code{eff.sum}}{
    sum of RND (a single value)}
  \item{\code{eff.interpretation}}{
    interpretation of the RND score}
}
}
\description{
Tabulate data for the \emph{Relative Norm Distance} (RND;
also known as \emph{Relative Euclidean Distance}) analysis.
This is an alternative method to \link[PsychWordVec:test_WEAT]{Single-Category WEAT}.
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
rnd = test_RND(
  demodata,
  T1=cc("
    architect, boss, leader, engineer, CEO, officer, manager,
    lawyer, scientist, doctor, psychologist, investigator,
    consultant, programmer, teacher, clerk, counselor,
    salesperson, therapist, psychotherapist, nurse"),
  A1=cc("male, man, boy, brother, he, him, his, son"),
  A2=cc("female, woman, girl, sister, she, her, hers, daughter"),
  labels=list(T1="Occupation", A1="Male", A2="Female"))
rnd

}
\references{
Garg, N., Schiebinger, L., Jurafsky, D., & Zou, J. (2018).
Word embeddings quantify 100 years of gender and ethnic stereotypes.
\emph{Proceedings of the National Academy of Sciences, 115}(16), E3635--E3644.

Bhatia, N., & Bhatia, S. (2021).
Changes in gender stereotypes over time: A computational analysis.
\emph{Psychology of Women Quarterly, 45}(1), 106--125.
}
\seealso{
\code{\link{tab_similarity}}

\code{\link{test_WEAT}}
}
