% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProteinPCA.R
\name{pca_analysis}
\alias{pca_analysis}
\title{Principal Component Analysis (PCA) Tool on Protein Expression Data}
\arguments{
\item{data}{A numeric matrix or data frame of protein expression data. Rows are samples, columns are features.}

\item{scale}{Logical. Should the data be scaled? Default is TRUE.}

\item{center}{Logical. Should the data be centered? Default is TRUE.}

\item{plot}{Logical. Should a PCA biplot be generated? Default is TRUE.}

\item{groups}{Optional. A factor or character vector specifying group memberships of the samples.}
}
\value{
A list containing:
\item{pca}{The PCA object from \code{prcomp}.}
\item{explained_variance}{The percentage of variance explained by each principal component.}
\item{plot}{A ggplot2 PCA biplot (if \code{plot = TRUE}).}
}
\description{
This function performs PCA on protein expression data and produces a biplot using ggplot2.
Optionally, it supports grouping/clustering visualization with PCA loadings and confidence ellipses.
}
\examples{
set.seed(123)
data_matrix <- matrix(rnorm(100 * 20), nrow = 100, ncol = 20)
rownames(data_matrix) <- paste0('Sample_', 1:100)
colnames(data_matrix) <- paste0('Protein_', 1:20)
groups <- sample(c("Group A", "Group B"), 100, replace = TRUE)
result <- pca_analysis(data_matrix, groups = groups)
print(result$explained_variance)
print(result$plot)

}
\references{
Jolliffe, I. (2001). Principal Component Analysis (2nd ed.). Springer. https://doi.org/10.1007/b98835
Gabriel, K. R. (1971). The biplot graphic display of matrices with application to principal component analysis. Biometrika, 58(3), 453–467. https://doi.org/10.1093/biomet/58.3.453
Zhang, Z., Chen, L., Sun, B., Ruan, Z., Pan, P., Zhang, W., Jiang, X., Zheng, S., Cheng, S., Xian, L., Wang, B., Yang, J., Zhang, B., Xu, P., Zhong, Z., Cheng, L., Ni, H., & Hong, Y. (2024). Identifying septic shock subgroups to tailor fluid strategies through multi-omics integration. Nature Communications, 15(1). https://doi.org/10.1038/s41467-024-53239-9
Anandan, A., Nagireddy, R., Sabarinathan, S., Bhatta, B. B., Mahender, A., Vinothkumar, M., Parameswaran, C., Panneerselvam, P., Subudhi, H., Meher, J., Bose, L. K., & Ali, J. (2022). Multi-trait association study identifies loci associated with tolerance of low phosphorus in Oryza sativa and its wild relatives. Scientific Reports, 12(1). https://doi.org/10.1038/s41598-022-07781-5
}
\author{
Paul Angelo C. Manlapaz
}
