% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.project.R
\name{get.project}
\alias{get.project}
\title{Show information about the current project.}
\usage{
get.project()
}
\value{
A named list.
}
\description{
This function will return all of the information that
ProjectTemplate has about the current project. This information is
gathered when \code{\link{load.project}} is called. At present,
ProjectTemplate keeps a record of the project's configuration settings,
all packages that were loaded automatically and all of the data sets that
were loaded automatically. The information about autoloaded data sets
is used by the \code{\link{cache.project}} function.
}
\details{
In previous releases this information has been available through the
  global variable \code{project.info}.  Using this variable is now deprecated
  and will result in a warning.
}
\examples{
library('ProjectTemplate')

\dontrun{load.project()

get.project()}
}
\seealso{
\code{\link{create.project}}, \code{\link{load.project}},
  \code{\link{cache.project}}, \code{\link{show.project}}
}
