% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/06PTModule.r
\docType{methods}
\name{appendPattern}
\alias{appendPattern}
\alias{appendPattern,PTModule,PTPattern-method}
\title{Append a PTPattern to a PTModule}
\usage{
\S4method{appendPattern}{PTModule,PTPattern}(x, pattern)
}
\arguments{
\item{x}{A \code{\link{PTModule}} object to which a
\code{\link{PTPattern}} is to be appended.}

\item{pattern}{A \code{\link{PTPattern}} object which is
to be appended to the \code{\link{PTModule}} \code{x}.}
}
\value{
Returns a \code{\link{PTModule}}, to which the
\code{\link{PTPattern}} is appended.
}
\description{
Appends a specified \code{\link{PTPattern}} to a
\code{\link{PTModule}}.
}
\details{
Depending on the \code{\link{trackerFlag}}, a ProTracker module can hold
either 64 or 100 pattern tables. As long as the number of pattern tables
is below this maximum, new pattern tables can be added to the module with
this function.

The \code{\link{patternOrder}} table should hold the maximum index of the
available pattern tables in a module, otherwise, the module is not valid.
As the maximum index increases, by appending a pattern table, the
\code{\link{patternOrder}} table should be updated. The
\code{\link{appendPattern}} method does this automatically, by replacing the first
non-unique index in the order table, outside the current order table's length,
with the new maximum index. If this is not possible, the highest element
in the order table is set to hold the maximum index.
}
\note{
As per ProTracker specification, the pattern indices
stored in the \code{\link{PTModule}} and obtained with
\code{\link{patternOrder}} start at 0. Whereas R starts indexing at 1.
Beware of this discrepancy.
}
\examples{
data("mod.intro")

## append an empty pattern to mod.intro

mod.intro <- appendPattern(mod.intro, new("PTPattern"))

## append a copy of pattern # 1 (this is pattern #0 in the
## patternOrder table) to mod.intro

mod.intro <- appendPattern(mod.intro, PTPattern(mod.intro, 1))
}
\author{
Pepijn de Vries
}
\seealso{
Other module.operations: \code{\link{PTModule}},
  \code{\link{PTModule-class}}; \code{\link{clearSamples}},
  \code{\link{clearSamples,PTModule-method}};
  \code{\link{clearSong}},
  \code{\link{clearSong,PTModule-method}};
  \code{\link{deletePattern}},
  \code{\link{deletePattern,PTModule,numeric-method}};
  \code{\link{modToWave}},
  \code{\link{modToWave,PTModule-method}};
  \code{\link{moduleSize}},
  \code{\link{moduleSize,PTModule-method}};
  \code{\link{patternLength}},
  \code{\link{patternLength,PTModule-method}};
  \code{\link{patternOrderLength}},
  \code{\link{patternOrderLength,PTModule-method}},
  \code{\link{patternOrderLength<-}},
  \code{\link{patternOrderLength<-,PTModule,numeric-method}};
  \code{\link{patternOrder}},
  \code{\link{patternOrder,PTModule-method}},
  \code{\link{patternOrder<-}},
  \code{\link{patternOrder<-,PTModule,ANY,numeric-method}};
  \code{\link{playMod}},
  \code{\link{playMod,PTModule-method}};
  \code{\link{playingtable}},
  \code{\link{playingtable,PTModule-method}};
  \code{\link{read.module}},
  \code{\link{read.module,ANY-method}},
  \code{\link{read.module,character-method}};
  \code{\link{trackerFlag}},
  \code{\link{trackerFlag,PTModule-method}},
  \code{\link{trackerFlag<-}},
  \code{\link{trackerFlag<-,PTModule-method}};
  \code{\link{write.module}},
  \code{\link{write.module,PTModule,ANY-method}},
  \code{\link{write.module,PTModule,character-method}}

Other pattern.operations: \code{\link{PTPattern,PTModule,numeric-method}},
  \code{\link{PTPattern,matrix,missing-method}},
  \code{\link{PTPattern,raw,missing-method}},
  \code{\link{PTPattern-method}},
  \code{\link{PTPattern<-}},
  \code{\link{PTPattern<-,PTModule,numeric,PTPattern-method}};
  \code{\link{PTPattern}}, \code{\link{PTPattern-class}};
  \code{\link{deletePattern}},
  \code{\link{deletePattern,PTModule,numeric-method}};
  \code{\link{pasteBlock}},
  \code{\link{pasteBlock,PTPattern,matrix,numeric,numeric-method}};
  \code{\link{patternLength}},
  \code{\link{patternLength,PTModule-method}};
  \code{\link{patternOrderLength}},
  \code{\link{patternOrderLength,PTModule-method}},
  \code{\link{patternOrderLength<-}},
  \code{\link{patternOrderLength<-,PTModule,numeric-method}};
  \code{\link{patternOrder}},
  \code{\link{patternOrder,PTModule-method}},
  \code{\link{patternOrder<-}},
  \code{\link{patternOrder<-,PTModule,ANY,numeric-method}}
}

