% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_congress_member.R
\name{get_congress_member}
\alias{get_congress_member}
\title{Get a Specific Member}
\usage{
get_congress_member(member_id, page = 1, myAPI_Key)
}
\arguments{
\item{member_id}{The ID of the member to retrieve; it is assigned by the Biographical Directory of the United States Congress or can be retrieved from a member list request.}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves biographical and Congressional role information for a particular member of Congress
}
\description{
To get biographical and Congressional role information for a particular member of Congress. HTTP Request: GET https://api.propublica.org/congress/v1/members/{member-id}.json
}
\examples{
\dontrun{
get_congress_member('K000388')
}
}
