% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/get_recent_personal_explanations_votes_by_category.R
\name{get_recent_personal_explanations_votes_by_category}
\alias{get_recent_personal_explanations_votes_by_category}
\title{Get Recent Personal Explanation Votes by Category}
\usage{
get_recent_personal_explanations_votes_by_category(
  congress,
  category,
  page = 1,
  myAPI_Key
)
}
\arguments{
\item{congress}{101-116}

\item{category}{options: voted-incorrectly (    Voted yes or no by mistake),    official-business (Away on official congressional business),    ambiguous (No reason given),    travel-difficulties (    Travel delays and issues),    personal (Personal or family reason),    claims-voted (Vote made but not recorded),    medical (    Medical issue for lawmaker, not family),    weather,    memorial,    misunderstanding,    leave-of-absence,    prior-commitment,    election-related,    military-service,    other}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recent personal explanation votes filtered by a category in the specified Congress.
}
\description{
Lawmakers, mostly in the House but also in the Senate, can make personal explanations for missed or mistaken votes in the Congressional Record. Unlike the “Recent Personal Explanations” response, this response contains explanations parsed to individual votes and have an additional category attribute describing the general reason for the absence or incorrect vote. HTTP Request: GET https://api.propublica.org/congress/v1/{congress}/explanations/votes/{category}.json
}
\examples{
\donttest{
get_recent_personal_explanations_votes_by_category(115, 'voted-incorrectly')
}
}
