% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_recent_official_communications_by_chamber.R
\name{get_recent_official_communications_by_chamber}
\alias{get_recent_official_communications_by_chamber}
\title{Get Recent Official Communications by Chamber}
\usage{
get_recent_official_communications_by_chamber(
  congress,
  chamber,
  page = 1,
  myAPI_Key
)
}
\arguments{
\item{congress}{114-116 for House, 96-116 for Senate}

\item{chamber}{house or senate}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recent official communications to Congress for a specific chamber for the specified chamber, either house or senate.
}
\description{
To get lists of official communications to Congress for a specific chamber, use the following function. HTTP Request: GET https://api.propublica.org/congress/v1/{congress}/{chamber}/committees/{committee-id}/subcommittees/{subcommittee-id}.json
}
\examples{
\donttest{
get_recent_official_communications_by_chamber(115, 'house')
}
}
