% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_full_multilateral_indices.R
\name{m_decomposition}
\alias{m_decomposition}
\title{Multiplicative decomposing the GEKS-type indices}
\usage{
m_decomposition(
  data,
  start,
  end,
  wstart = start,
  formula = c(),
  window = 13,
  sigma = 0.7,
  index.value = TRUE
)
}
\arguments{
\item{data}{The user's data frame with information about sold products. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01'), \code{prices} (as positive numeric), \code{quantities}  (as positive numeric) and \code{prodID} (as numeric, factor or character).}

\item{start}{The base period (as character) limited to the year and month, e.g. "2020-03".}

\item{end}{The research period (as character) limited to the year and month, e.g. "2020-04".}

\item{wstart}{The beginning of the time interval (which is used by multilateral methods) limited to the year and month, e.g. "2020-01".}

\item{formula}{A parameter indicating which multilateral formulas are to be decomposed. In the current version of the package, the multiplicative decomposition includes the following GEKS-type indices: GEKS, CCDI, GEKS-W, GEKS-L, GEKS-GL and GEKS-LM. Thus, this parameter can take values like: “geks”, ‘ccdi’, ‘geksw’ ‘geksl’, ‘geksgl’, ‘gekslm’.}

\item{window}{The length of the time window (as positive integer: typically multilateral methods are based on the 13-month time window).}

\item{sigma}{The elasticity of substitution (a parameter used in the Lloyd-Moulton index formula). The default value is 0.7.}

\item{index.value}{The parameter indicating whether price index values are to be displayed (at the end of the returned \code{multiplicative} data frame).}
}
\value{
This function returns a list with three elements: \code{multiplicative} - a data frame containing multiplicative decompositions of the indicated GEKS-type indices, \code{normalized} - normalized multiplicative decompositions of the indicated indices (their product is always 1), \code{impact} - relative impacts of commodities on the price index value (in p.p.).
}
\description{
This function returns multiplicative decompositions of the selected GEKS-type indices.
}
\examples{
\donttest{m_decomposition(milk, start="2018-12",end="2019-12",formula=c("geks","ccdi"))$multiplicative}
}
\references{
{Webster, M., Tarnow-Mordi, R. C. (2019). \emph{Decomposing Multilateral Price Indexes into the Contributions of Individual Commodities}, Journal of Official Statistics, 35(2), 461-486.}
}
