% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_comparing_indices.R
\name{compare_indices_jk}
\alias{compare_indices_jk}
\title{A general function to compare indices by using the jackknife method}
\usage{
compare_indices_jk(
  data,
  start,
  end,
  by = "prodID",
  formula = c(),
  window = c(),
  splice = c(),
  base = c(),
  sigma = c(),
  r = c(),
  names = c(),
  title = c()
)
}
\arguments{
\item{data}{The user's data frame with information about sold products. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01'), \code{prices} (as positive numeric) and \code{prodID} (as numeric, factor or character). A column \code{quantities} (as positive numeric) is also essential even if the selected index is an unweighted formula (unit values are calculated).}

\item{start}{The base period (as character) limited to the year and month, e.g. "2019-12".}

\item{end}{The research period (as character) limited to the year and month, e.g. "2020-04".}

\item{by}{A character string which indicates a column name for creating product subgroups (in the classical jackknife method \code{by} should indicate \code{prodID}). In each, successive repetition, the indicated price indexes are counted on the set of products reduced by the subset determined by the successive element of the column indicated by the \code{by} parameter.}

\item{formula}{A vector of character strings indicating price index formulas that are to be calculated. To see available options please use the link: \code{\link{PriceIndices}}.}

\item{window}{A vector of integers. Each element of the vector defines the length of the time window of the corresponding multilateral index.}

\item{splice}{A vector of character strings. Each element of the vector indicates the splicing method is to be used for the corresponding multilateral index. Available values of vector elements are: "movement", "window","half","mean" and their additional variants: "window_published", "half_published" and "mean_published".}

\item{base}{The vector of prior periods used in the Young- or Lowe-type price indices or hybrid/geohybrid index. Each element of the vector (as character) must be limited to the year and month, e.g. "2020-01".}

\item{sigma}{The vector of elasticity of substitution parameters used in the Lloyed-Moulton, AG Mean or GEKS-LM indices (as numeric).}

\item{r}{The vector of non-zero parameters used in the quadratic mean of order r quantity / price index or in the GEKS-QM index (as numeric).}

\item{names}{A vector of strings indicating names of indices which are to be used in the resulting data frame.}

\item{title}{A character string indicating a title of the created box-plot.}
}
\value{
This function presents a comparison of selected indices obtained by using the jackknife method. In particular, it returns a list with two elements: \code{results}, which is a data frame with basic characteristics of the calculated indices (means and standard deviations) , and \code{figure} which presents a box-plot for the considered indices.
}
\description{
This function presents a comparison of selected indices obtained by using the jackknife method.
}
\examples{
\donttest{#creating a list with jackknife results
comparison<-compare_indices_jk(milk,
formula=c("jevons","fisher","geks"),
start="2018-12",
end="2019-12", 
window=c(13),
names=c("Jevons","Fisher","GEKS"), 
by="retID",
title="Jackknife box-plots for milk products")
#displaying results
comparison$results
comparison$figure}
}
\references{
{Quenouille, M.H. (1956). \emph{Notes on bias in estimation}. Biometrika, 43 (3–4), 353–360}

{(2004). \emph{Consumer Price Index Manual. Theory and practice}. ILO/IMF/OECD/UNECE/Eurostat/The World Bank, International Labour Office (ILO), Geneva.}
}
