% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PostPrInDT.R
\name{PostPrInDT}
\alias{PostPrInDT}
\title{Posterior analysis of conditional inference trees: distribution of a specified variable in the terminal nodes.}
\usage{
PostPrInDT(datain, ct, target, var, vardata, vt)
}
\arguments{
\item{datain}{input data frame with the observatios of all variables used in the model}

\item{ct}{conditional inference tree to be analyzed}

\item{target}{name of target variable of 'ct' (character)}

\item{var}{name of variable of interest (character)}

\item{vardata}{observations of 'var'}

\item{vt}{type of variables: 'dd' for discrete target (classification) and discrete variable 'var', 'dc' for discrete target (classification) and continuous 'var',
'cd' for continuous target (regression) and discrete 'var', and 'cc' for continuous target (regression) and continuous 'var'.}
}
\value{
None: Relevant output is produced by the function.
}
\description{
The conditional inference tree 'ct' is analyzed according to the distribution of a variable 'var' in its terminal nodes.\cr
In the case of a discrete variable 'var', the appearance of the different levels is considered for each terminal node. \cr
In the case of a continuous variable 'var', means and standard deviations of 'var' or the target variable are considered for each terminal node.\cr
In particular, this function can be used for the posterior analysis of a tree regarding the distribution of a variable not present in the tree.
}
\examples{
data <- PrInDT::data_zero
data <- na.omit(data)
outAll <- PrInDTAll(data,"real") 
PostPrInDT(data,outAll$treeAll,"real","ETH",data$ETH,vt="dd")
PostPrInDT(data,outAll$treeAll,"real","AGE",data$AGE,vt="dc")
datareg <- PrInDT::data_vowel
outregAll <- PrInDTregAll(datareg,"target") 
PostPrInDT(datareg,outregAll$treeAll,"target","Nickname",datareg$Nickname,vt="cd")
PostPrInDT(datareg,outregAll$treeAll,"target","AGE",datareg$AGE,vt="cc")

}
