% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_sim_model}
\alias{plot_sim_model}
\alias{plot_sim_model.formula}
\alias{plot_sim_model.PowRPriori}
\title{Visualize Simulation Data or Power Simulation Results}
\usage{
plot_sim_model(
  x,
  type,
  design,
  fixed_effects,
  random_effects,
  family,
  n,
  x_var,
  group_var,
  color_var,
  facet_var,
  n_data_points,
  ...
)

\method{plot_sim_model}{formula}(
  x,
  type = NULL,
  design,
  fixed_effects,
  random_effects,
  family = "gaussian",
  n,
  x_var = NULL,
  group_var = NULL,
  color_var = NULL,
  facet_var = NULL,
  n_data_points = 10,
  ...
)

\method{plot_sim_model}{PowRPriori}(
  x,
  type = "power_curve",
  design = NULL,
  fixed_effects = NULL,
  random_effects = NULL,
  family = NULL,
  n = NULL,
  x_var = NULL,
  group_var = NULL,
  color_var = NULL,
  facet_var = NULL,
  n_data_points = 10,
  ...
)
}
\arguments{
\item{x}{The object to plot.}

\item{type}{The type of plot to create: \code{"power_curve"} (default) or \code{"data"}
(to visualize the sample data from the simulation).}

\item{design}{A \code{PowRPriori_design} object.}

\item{fixed_effects, random_effects}{Lists of effect parameters.}

\item{family}{The model family (e.g., \code{"gaussian"}).}

\item{n}{The total sample size to simulate for the plot.}

\item{x_var, group_var, color_var, facet_var}{Strings specifying variables for plot aesthetics.}

\item{n_data_points}{The maximum number of trajectories in spaghetti plots.}

\item{...}{Additional arguments (not used).}
}
\value{
A \code{ggplot} object.
}
\description{
Generic plotting function with methods for different objects.
\itemize{
\item When used on an lme4-style \code{formula}, it simulates and plots a single plausible dataset.
\item When used on a \code{PowRPriori} object, it plots either a power curve from the object or a dataset from the simulation.
}

The plotting of the dataset is designed to aid in evaluating whether the simulated data is plausible in the context
of the desired study design and model specifications. It can help determine whether the chosen parameters are sensible or might
need some adapting. The power curve, plotted from the resulting \code{PowRPriori} object of the \code{power_sim} function visualizes the iterations
of the simulation across the different sample sizes for which the power was calculated during simulation.
}
\details{
The parameters \verb{x_var, group_var, color_var and facet_var} are \code{NULL} by default. If left \code{NULL}, they are automatically extracted from the \code{PowRPriori} object
or the \code{design} object.
}
\examples{
# 1. Plot prior to simulation to check data plausibility
design <- define_design(
  id = "subject",
  between = list(group = c("Control", "Treatment")),
  within = list(time = c("pre", "post"))
)

fixed_effects <- list(
  `(Intercept)` = 10,
  groupTreatment = 2,
  timepost = 1,
  `groupTreatment:timepost` = 3
)

random_effects <- list(
  subject = list(`(Intercept)` = 3),
  sd_resid = 3
)

plot_sim_model(
  y ~ group * time + (1|subject),
  design = design,
  fixed_effects = fixed_effects,
  random_effects = random_effects,
  n = 30
)
\donttest{
# 2. Plot from PowRPriori object after simulation
  power_results <- power_sim(
    formula = y ~ group * time + (1|subject),
    design = design,
    fixed_effects = fixed_effects,
    random_effects = random_effects,
    test_parameter = "groupTreatment:timepost",
    n_start = 20,
    n_increment = 5,
    n_sims = 100, # Using a smaller n_sims for a quick example
    parallel_plan = "multisession"
  )

  # Power curve
  plot_sim_model(power_results, type = "power_curve")

  # Plot sample data with automated aesthetics extraction
  plot_sim_model(power_results, type = "data")
}
}
