/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.loader;

import java.util.ArrayList;
import org.openfast.QName;
import org.openfast.error.FastConstants;
import org.openfast.template.Field;
import org.openfast.template.Group;
import org.openfast.template.loader.AbstractFieldParser;
import org.openfast.template.loader.FieldParser;
import org.openfast.template.loader.ParsingContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GroupParser
extends AbstractFieldParser {
    public GroupParser() {
        super("group");
    }

    protected Field parse(Element groupElement, boolean optional, ParsingContext context) {
        Group group = new Group(context.getName(), GroupParser.parseFields(groupElement, context), optional);
        GroupParser.parseMore(groupElement, group, context);
        return group;
    }

    protected static void parseMore(Element groupElement, Group group, ParsingContext context) {
        group.setChildNamespace(context.getNamespace());
        if (groupElement.hasAttribute("id")) {
            group.setId(groupElement.getAttribute("id"));
        }
        group.setTypeReference(GroupParser.getTypeReference(groupElement, context));
        GroupParser.parseExternalAttributes(groupElement, group);
    }

    protected static Field[] parseFields(Element template, ParsingContext context) {
        NodeList childNodes = template.getChildNodes();
        ArrayList<Field> fields = new ArrayList<Field>();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node item = childNodes.item(i);
            if (GroupParser.isElement(item) && !"typeRef".equals(item.getNodeName()) && !"length".equals(item.getNodeName())) {
                Element element = (Element)item;
                FieldParser fieldParser = context.getFieldParser(element);
                if (fieldParser == null) {
                    context.getErrorHandler().error(FastConstants.PARSE_ERROR, "No parser registered for " + element.getNodeName());
                }
                fields.add(fieldParser.parse(element, context));
            }
            ++i;
        }
        return fields.toArray(new Field[0]);
    }

    protected static QName getTypeReference(Element templateTag, ParsingContext context) {
        String typeReference = null;
        String typeRefNs = context.getNamespace();
        NodeList typeReferenceTags = templateTag.getElementsByTagName("typeRef");
        if (typeReferenceTags.getLength() > 0) {
            Element messageRef = (Element)typeReferenceTags.item(0);
            typeReference = messageRef.getAttribute("name");
            if (messageRef.hasAttribute("ns")) {
                typeRefNs = messageRef.getAttribute("ns");
            }
            return new QName(typeReference, typeRefNs);
        }
        return FastConstants.ANY_TYPE;
    }
}

