/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.message;

import com.portfolioeffect.quant.client.message.AbstractMessage;
import com.portfolioeffect.quant.client.message.util.ArrayUtil;

public class TransmitDataRequest
extends AbstractMessage {
    private static final long serialVersionUID = -5922745454349158176L;
    private final int dataLength;
    private final byte[] dataInt;
    private final byte[] dataFloat;
    private final byte[] time;

    public TransmitDataRequest(String msgType, String msgBody, byte[] dataInt, byte[] dataFloat, byte[] time, int dataLength) {
        super(msgType, msgBody);
        this.dataFloat = dataFloat;
        this.dataInt = dataInt;
        this.time = time;
        this.dataLength = dataLength;
    }

    public byte[] getDataIntByte() {
        return this.dataInt;
    }

    public int[] getDataInt() throws Exception {
        if (this.dataInt == null) {
            throw new Exception("No such type data: dataInt");
        }
        return ArrayUtil.unpackAndDecompressInts(this.dataLength, this.dataInt);
    }

    public byte[] getDataFloatByte() {
        return this.dataFloat;
    }

    public float[] getDataFloat() throws Exception {
        if (this.dataFloat == null) {
            throw new Exception("No such type data: dataFloat");
        }
        return ArrayUtil.unpackAndDecompressFloats(this.dataLength, this.dataFloat);
    }

    public byte[] getDataTimeByte() {
        return this.time;
    }

    public long[] getTime() throws Exception {
        if (this.time == null) {
            throw new Exception("No such type data: time");
        }
        return ArrayUtil.unpackAndDecompressLongs(this.dataLength, this.time);
    }

    public int getDataLength() {
        return this.dataLength;
    }
}

