\name{outputBottleSim}
\alias{outputBottleSim}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Converts alleles from BottleSim simulation results to real allele sizes as found in the input file generated with the function \code{\link{inputBottleSim}}
%%  ~~function to do ... ~~
}
\description{The population genetics simulation software BottleSim (Kuo and Janzen 2003) uses an unconventional input file format. The function \code{\link{inputBottleSim}} creates automatically such input files. After BottleSim simulations are performed, a Genepop file containing genotypes of all replicates (each replicate is labelled as a different 'population') is produced, but alleles are coded in a different manner that makes comparison with the starting real data impossible (for instance, one may be interested in calculating Fst values between simulated populations and the real data). This function converts alleles back to their original sizes. It also allows the user to retain only a random subset of individuals for each replicate. Real and simulated data can subsequently be combined for analysis with the function \code{\link{combineBsim}}. 
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
outputBottleSim(datafile, subsample = 0)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{datafile}{Name of the output file generated by BottleSim (with the extension) containing multilocus genotypes for all simulation replicates.
%%     ~~Describe \code{datafile} here~~
}
  \item{subsample}{Number of individuals to retain in each replicate. Individuals are chosen randomly in each replicate. Zero (default value) means all individuals will be kept.
%%     ~~Describe \code{subsample} here~~
}
}
\details{To use this function, the input file for BottleSim simulations first needs to be created using the function \code{\link{inputBottleSim}}. This will also create a file called 'alleles' in which all required information about allele numbers and sizes is stored. Once BottleSim simulations are done and a genotype file is obtained, it is necessary to put the 'alleles' file in the same directory as the BottleSim genotype output file before using this function.
%%  ~~ If necessary, more details than the description above ~~
}
\value{A new Genepop file will be saved in the working directory, with the suffix 'OKAllelesBsim'. 
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
\references{Kuo C.H., and F.J.Janzen (2003). BottleSim: a bottleneck simulation program for long-lived species with overlapping generations. Mol. Ecol. Notes 3, 669-673.

Rousset, F. (2008). Genepop'007: a complete reimplementation of the Genepop software for Windows and Linux. Mol. Ecol. Res. 8: 103-106. 

%% ~put references to the literature/web site here ~
}
\author{Sebastien Rioux Paquette
%%  ~~who you are~~
}
\seealso{\code{\link{inputBottleSim}}, \code{\link{combineBsim}}
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
