% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{getGameteFreqs}
\alias{getGameteFreqs}
\title{get all gametes and their frequencies for a parental
haplotype combination}
\usage{
getGameteFreqs(parhac, DRrate)
}
\arguments{
\item{parhac}{vector of the parental haplotype combination of length <ploidy>,
giving the <ploidy> haplotype numbers present
per haplotype giving the dosage of that haplotype, summing to ploidy}

\item{DRrate}{the rate of double reduction per meiosis (NOT per allele!); e.g.
with a DRrate of 0.04, a tetraploid parent with genotype ABCD will produce
a fraction of 0.04 of DR gametes AA, BB, CC and DD (each with a frequency of
0.01), and a fraction of 0.96 of the non-DR gametes AB, AC, AD, BC, BD, CD
(each with a frequency of 0.16)}
}
\value{
a list of 2 elements:\cr
hapcomb: a matrix with one column per unique gamete and ploidy/2 rows.
Each element is the number (ID) of a haplotype). Within columns the
haplotypes are sorted from low to high; the columns are ordered from left
to right, first on row 1, then on row 2 etc\cr
freq: a vector of length ncol(hapcomb), with for each gamete in hapcomb its
frequency (0.0 ... 1.0)
}
\description{
get all gametes and their frequencies for a parental
haplotype combination
}
\details{
for hexaploids the DR gametes consist of a duplication of one of the
6 parental alleles, combined with one copy of one of the other 5 alleles.\cr
Calculation is faster if DRrate is 0.0
}
\examples{
# specify combination of haplotypes in a tetraploid parent:
hapcomb <- c(2,2,5,6) # 2 copies of haplotype 2, 1 each of 5 and 6
# gamete frequencies without double reduction:
getGameteFreqs(parhac=hapcomb, DRrate=0)
# gamete frequencies with 5\\% double reduction:
getGameteFreqs(parhac=hapcomb, DRrate=0.05)
}
