% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_rarefaction.R
\name{VDJ_rarefaction}
\alias{VDJ_rarefaction}
\title{Plots rarefaction curves for species denoted in the feature.columns parameter across groups determined by grouping.columns}
\usage{
VDJ_rarefaction(
  VDJ,
  feature.columns,
  grouping.column,
  VDJ.VJ.1chain,
  rarefaction.type,
  hill.numbers,
  number.resamples,
  sample.sizes,
  endpoint
)
}
\arguments{
\item{VDJ}{VDJ dataframe output from the VDJ_GEX_matrix function.}

\item{feature.columns}{Character vector. One or more column names from the VDJ to indicate the unique species for the rarefaction (to rarefy across). If more than one column is provided (e.g. c("VDJ_cdr3s_aa","VJ_cdr3s_aa")) these columns will be pasted together.}

\item{grouping.column}{Character. Column name of a column to group the rarefaction by. This could be "sample_id" for rarefaction curves for each sample.}

\item{VDJ.VJ.1chain}{Boolean defaults to TRUE. Whether to filter out aberrant cells (more than 1 VDJ or VJ chain).}

\item{rarefaction.type}{Character. Options for the iNEXT rarefaction - 'sample.size','coverage.based', or 'sample.completeness'.}

\item{hill.numbers}{Integer/ vector of integers. The Hill numbers to be plotted out (0 - species richness, 1 - Shannon diversity, 2 - Simpson  diversity)}

\item{number.resamples}{Integer. Number of bootstrap replications.}

\item{sample.sizes}{Vector if integers. The sample size points at which rarefaction should be performed. Defaults to NULL}

\item{endpoint}{Integer. The maximum sample size for rarefaction extrapolation. Defaults to NULL = 2 times the sample size for each sample.}
}
\value{
Returns a ggplot with the ordination analysis performer across features, groups, or both
}
\description{
Plots rarefaction curves for species denoted in the feature.columns parameter across groups determined by grouping.columns
}
\examples{

\donttest{
try({
plot <- VDJ_diversity(VDJ = Platypus::small_vgm[[1]],
,feature.columns = c("VDJ_cdr3s_aa"), grouping.column = "sample_id")
})
}
}
