% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEX_GSEA.R
\name{GEX_GSEA}
\alias{GEX_GSEA}
\title{GEX Gene Set Enrichment Analysis and plotting}
\usage{
GEX_GSEA(
  GEX.cluster.genes.output,
  MT.Rb.filter,
  filter,
  path.to.pathways,
  metric.colname,
  pval.adj.cutoff,
  Enrichment.Plots,
  my.own.geneset,
  eps,
  platypus.version
)
}
\arguments{
\item{GEX.cluster.genes.output}{Data frame containing the list of gene symbols and a metric. Function works directly with GEX_cluster_genes output.}

\item{MT.Rb.filter}{Logical, should Mitotic and Ribosomal genes be filtered out of the geneset. True by default.}

\item{filter}{Character vector containing the identifying symbol sequence for the genes which should be filtered out, if MT.Rb.filter == TRUE. By default set to c("MT-", "RPL", "RPS").}

\item{path.to.pathways}{Either a path to gmt file containing the gene sets (can be downloaded from MSigDB) or vector where first element specifies species and second element specifies the MSigDB collection abbreviation. E.g.: c("Homo sapiens", "H"). Mouse C7 (immunologic signature) gene set will be used by default.}

\item{metric.colname}{Name of column which contains the metric used for the ranking of the submitted genelist. "avg_logFC" is used by default.}

\item{pval.adj.cutoff}{Only genes with a more significant adjusted pvalue are considered. Default: 0.001}

\item{Enrichment.Plots}{List of Gene-set names which should be plotted as Enrichment plots in addition to the top 10 Up and Downregulated Genesets.}

\item{my.own.geneset}{A list, where each element contains a gene list and is named with the corresponding pathway name. Default is set to FALSE, so that gene sets from MSigDB are used. Should not contain ".gmt" in name.}

\item{eps}{Numeric, specifying boundary for calculating the p value in the GSEA.}

\item{platypus.version}{Function works with V2 and V3, no need to set this parameter.}
}
\value{
Returns a list containing a tibble with the gene sets and their enrichment scores and Enrichment plots. List element [[1]]: Dataframe with Genesets and statistics. [[2]]: Enrichment plots of top10 Up regulated genesets. [[3]]: Enrichment plots of top10 Down regulated genesets. [[4]]: Enrichment plots of submited gene-sets in parameter Enrichment.Plot.
}
\description{
Conducts a Gene Set Enrichment Analysis (GSEA) on a set of genes submitted in a data frame with a metric each.
Works with the output of GEX_genes_cluster or a custom data frame containing the gene symbols either in a column "symbols" or as rownames and a metric for each gene.
The name of the column containing the metric has to be declared via the input metric.colname.
}
\examples{
\donttest{
try({
df <- GEX_cluster_genes(Platypus::small_vgm[[2]])

output <- GEX_GSEA(GEX.cluster.genes.output =  df[[1]], MT.Rb.filter = TRUE
, path.to.pathways = "./c5.go.bp.v7.2.symbols.gmt")
cowplot::plot_grid(plotlist=output[[2]], ncol=2)

output <- GEX_GSEA(GEX.cluster.genes.output =  df[[1]], MT.Rb.filter = TRUE
, path.to.pathways = c("Mus musculus", "C7"))

output <- GEX_GSEA(GEX.cluster.genes.output =  df[[1]], MT.Rb.filter = TRUE
, my.own.geneset = my_geneset)
})
}
}
