% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_1.1.10.R
\name{DetectPlasmaMutation}
\alias{DetectPlasmaMutation}
\title{function DetectPlasmaMutation}
\usage{
DetectPlasmaMutation(
  patient.dir = "./",
  patient.name = NULL,
  pos_ranges.file = NULL,
  ber.ctrl.file = NULL,
  bai.ext = ".bai",
  alpha = 0.05,
  n.trim = 0,
  force = FALSE,
  show.more = FALSE,
  qcutoff.snv = 1,
  qcutoff.indel = 1,
  cutoff.sb.hotspot = Inf,
  cutoff.sb.nonhotspot = cutoff.sb.hotspot,
  cutoff.sb.indel = cutoff.sb.hotspot,
  cutoff.sb.ref = 0.9,
  hotspot.indel = "chr7:55227950:55249171",
  output.dir = patient.dir
)
}
\arguments{
\item{patient.dir, }{char, foldername containing the rBAM folder of the patients. The typical folder hierarchy will consist of 'Plasma/rBAM'}

\item{patient.name, }{char, filename of the patient .bam file(s) (default NULL read all patients in folder \code{patient.dir})}

\item{pos_ranges.file, }{char, name of the Rdata file containing the three variables \code{pos_ind}, \code{pos_snp}, \code{pos_ranges} as build by the function \code{PrepareLibrary}. Default NULL, use the position_ranges.rda provides that we used for our analysis.}

\item{ber.ctrl.file, }{char, pathname of the file providing the background error rates obtained from the controls (default NULL use the provided background error rates obtained from our 29 controls). See \code{background_error_rate.txt} data and \code{BuildCtrlErrorRate} function.}

\item{bai.ext, }{char, filename extension of the bai files (default '.bai')}

\item{alpha, }{num, global false positive rate = global test level (default 0.05)}

\item{n.trim, }{integer, number of base positions trimmed at the ends of each amplicon (default 0)}

\item{force, }{boolean, (default FALSE) if TRUE force all computations to all files including already processed ones}

\item{show.more, }{boolean, (default FALSE show only detected positions) if TRUE additional annotations on result plots are given for non-significant mutations}

\item{qcutoff.snv, }{numeric, proportion of kept base positions ranged by increasing percentile SNV PER in control samples (default 1)}

\item{qcutoff.indel, }{numeric, proportion of kept base positions ranged by increasing percentile INDEL PER in control samples (default 1)}

\item{cutoff.sb.hotspot, }{numeric, exclude hotspot positions without Symmetric Odds Ratio test < cutoff (default 1)}

\item{cutoff.sb.nonhotspot, }{numeric, exclude non-hotspot positions without Symmetric Odds Ratio test < cutoff (default cutoff.sb.hotspot)}

\item{cutoff.sb.indel, }{numeric, exclude indel positions without Symmetric Odds Ratio test < cutoff (default cutoff.sb.hotspot)}

\item{cutoff.sb.ref, }{numeric, exclude ref positions without Symmetric Odds Ratio test < cutoff (default cutoff = 0.9)}

\item{hotspot.indel, }{char, a vector containing the known positions of hotspot deletion/insertion defined as chrX:start:end (default 'chr7:55227950:55249171')}

\item{output.dir, }{char, name of the folder to save results  (default \code{patient.dir}).}
}
\value{
the number of processed patients
}
\description{
This is the main function of the package that calls mutations by comparing at each genomic position the SNV or INDEL frequencies computed in one tested sample to
the SNV or INDEL Position-Error Rates computed from several control samples by a binomial test. An outlier detection is performed among all intra-sample p-values
to call a mutation.
For users wishing to develop their own analysis for other sequencing panel, it requires recalibrated BAM files control samples to be processed to compute the
Position-Error Rates stored in a file specified in \code{ber.ctrl.file}.
}
\examples{
     patient.dir=system.file("extdata","4test_only/case/",package="PlasmaMutationDetector2")
     if (substr(patient.dir,nchar(patient.dir),nchar(patient.dir))!='/')
       patient.dir = paste0(patient.dir,'/') # TO RUN UNDER WINDOWS
     DetectPlasmaMutation(patient.dir,output.dir=paste0(tempdir(),'/'))


}
\references{
\emph{Analysis of base-position error rate of next-generation sequencing to detect tumor mutations in circulating DNA} N. Pécuchet, Y. Rozenholc, E. Zonta, D. Pietraz, A. Didelot, P. Combe, L. Gibault, J-B. Bachet, V. Taly, E. Fabre, H. Blons and P. Laurent-Puig in \emph{Clinical Chemistry}

\emph{Novel hybridization- and tag-based error-corrected method for sensitive ctDNA mutation detection using ion semiconductor sequencing} Kjersti Tjensvoll, Morten Lapin, Bjørnar Gilje, Herish Garresori, Satu Oltedal, Rakel Brendsdal Forthun, Anders Molven, Yves Rozenholc and Oddmund Nordgård  in \emph{Scientific Reports}
}
\author{
N. Pécuchet, P. Laurent-Puig, O. Nordgård and Y. Rozenholc
}
